/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsClient;
import software.amazon.awssdk.services.budgets.internal.UserAgentUtils;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse;
import software.amazon.awssdk.services.budgets.model.Notification;

public class DescribeNotificationsForBudgetIterable
implements SdkIterable<DescribeNotificationsForBudgetResponse> {
    private final BudgetsClient client;
    private final DescribeNotificationsForBudgetRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeNotificationsForBudgetIterable(BudgetsClient client, DescribeNotificationsForBudgetRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeNotificationsForBudgetResponseFetcher();
    }

    public Iterator<DescribeNotificationsForBudgetResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Notification> notifications() {
        Function<DescribeNotificationsForBudgetResponse, Iterator> getIterator = response -> {
            if (response != null && response.notifications() != null) {
                return response.notifications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeNotificationsForBudgetResponseFetcher
    implements SyncPageFetcher<DescribeNotificationsForBudgetResponse> {
        private DescribeNotificationsForBudgetResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNotificationsForBudgetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeNotificationsForBudgetResponse nextPage(DescribeNotificationsForBudgetResponse previousPage) {
            if (previousPage == null) {
                return DescribeNotificationsForBudgetIterable.this.client.describeNotificationsForBudget(DescribeNotificationsForBudgetIterable.this.firstRequest);
            }
            return DescribeNotificationsForBudgetIterable.this.client.describeNotificationsForBudget((DescribeNotificationsForBudgetRequest)((Object)DescribeNotificationsForBudgetIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

