/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsClient;
import software.amazon.awssdk.services.budgets.model.ActionHistory;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetActionHistoriesResponse;

public class DescribeBudgetActionHistoriesIterable
implements SdkIterable<DescribeBudgetActionHistoriesResponse> {
    private final BudgetsClient client;
    private final DescribeBudgetActionHistoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBudgetActionHistoriesIterable(BudgetsClient client, DescribeBudgetActionHistoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeBudgetActionHistoriesResponseFetcher();
    }

    public Iterator<DescribeBudgetActionHistoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActionHistory> actionHistories() {
        Function<DescribeBudgetActionHistoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionHistories() != null) {
                return response.actionHistories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeBudgetActionHistoriesResponseFetcher
    implements SyncPageFetcher<DescribeBudgetActionHistoriesResponse> {
        private DescribeBudgetActionHistoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBudgetActionHistoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeBudgetActionHistoriesResponse nextPage(DescribeBudgetActionHistoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeBudgetActionHistoriesIterable.this.client.describeBudgetActionHistories(DescribeBudgetActionHistoriesIterable.this.firstRequest);
            }
            return DescribeBudgetActionHistoriesIterable.this.client.describeBudgetActionHistories((DescribeBudgetActionHistoriesRequest)((Object)DescribeBudgetActionHistoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

