/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.budgets.model.BudgetsResponse;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.services.budgets.model.NotificationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNotificationsForBudgetResponse
extends BudgetsResponse
implements ToCopyableBuilder<Builder, DescribeNotificationsForBudgetResponse> {
    private static final SdkField<List<Notification>> NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Notifications").getter(DescribeNotificationsForBudgetResponse.getter(DescribeNotificationsForBudgetResponse::notifications)).setter(DescribeNotificationsForBudgetResponse.setter(Builder::notifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Notification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeNotificationsForBudgetResponse.getter(DescribeNotificationsForBudgetResponse::nextToken)).setter(DescribeNotificationsForBudgetResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Notification> notifications;
    private final String nextToken;

    private DescribeNotificationsForBudgetResponse(BuilderImpl builder) {
        super(builder);
        this.notifications = builder.notifications;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNotifications() {
        return this.notifications != null && !(this.notifications instanceof SdkAutoConstructList);
    }

    public final List<Notification> notifications() {
        return this.notifications;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotifications() ? this.notifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationsForBudgetResponse)) {
            return false;
        }
        DescribeNotificationsForBudgetResponse other = (DescribeNotificationsForBudgetResponse)((Object)obj);
        return this.hasNotifications() == other.hasNotifications() && Objects.equals(this.notifications(), other.notifications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNotificationsForBudgetResponse").add("Notifications", this.hasNotifications() ? this.notifications() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Notifications": {
                return Optional.ofNullable(clazz.cast(this.notifications()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotificationsForBudgetResponse, T> g) {
        return obj -> g.apply((DescribeNotificationsForBudgetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BudgetsResponse.BuilderImpl
    implements Builder {
        private List<Notification> notifications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationsForBudgetResponse model) {
            super(model);
            this.notifications(model.notifications);
            this.nextToken(model.nextToken);
        }

        public final Collection<Notification.Builder> getNotifications() {
            if (this.notifications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notifications != null ? (Collection)this.notifications.stream().map(Notification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notifications(Collection<Notification> notifications) {
            this.notifications = NotificationsCopier.copy(notifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Notification ... notifications) {
            this.notifications(Arrays.asList(notifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notifications(Consumer<Notification.Builder> ... notifications) {
            this.notifications(Stream.of(notifications).map(c -> (Notification)((Notification.Builder)Notification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNotifications(Collection<Notification.BuilderImpl> notifications) {
            this.notifications = NotificationsCopier.copyFromBuilder(notifications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNotificationsForBudgetResponse build() {
            return new DescribeNotificationsForBudgetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BudgetsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNotificationsForBudgetResponse> {
        public Builder notifications(Collection<Notification> var1);

        public Builder notifications(Notification ... var1);

        public Builder notifications(Consumer<Notification.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

