/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request of DeleteSubscriber
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSubscriberRequest extends BudgetsRequest implements
        ToCopyableBuilder<DeleteSubscriberRequest.Builder, DeleteSubscriberRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteSubscriberRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteSubscriberRequest::budgetName)).setter(setter(Builder::budgetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()).build();

    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.<Notification> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteSubscriberRequest::notification)).setter(setter(Builder::notification))
            .constructor(Notification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()).build();

    private static final SdkField<Subscriber> SUBSCRIBER_FIELD = SdkField.<Subscriber> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteSubscriberRequest::subscriber)).setter(setter(Builder::subscriber))
            .constructor(Subscriber::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscriber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BUDGET_NAME_FIELD, NOTIFICATION_FIELD, SUBSCRIBER_FIELD));

    private final String accountId;

    private final String budgetName;

    private final Notification notification;

    private final Subscriber subscriber;

    private DeleteSubscriberRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
        this.subscriber = builder.subscriber;
    }

    /**
     * <p>
     * The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.
     * </p>
     * 
     * @return The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the budget whose subscriber you want to delete.
     * </p>
     * 
     * @return The name of the budget whose subscriber you want to delete.
     */
    public String budgetName() {
        return budgetName;
    }

    /**
     * <p>
     * The notification whose subscriber you want to delete.
     * </p>
     * 
     * @return The notification whose subscriber you want to delete.
     */
    public Notification notification() {
        return notification;
    }

    /**
     * <p>
     * The subscriber that you want to delete.
     * </p>
     * 
     * @return The subscriber that you want to delete.
     */
    public Subscriber subscriber() {
        return subscriber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(notification());
        hashCode = 31 * hashCode + Objects.hashCode(subscriber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSubscriberRequest)) {
            return false;
        }
        DeleteSubscriberRequest other = (DeleteSubscriberRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(budgetName(), other.budgetName())
                && Objects.equals(notification(), other.notification()) && Objects.equals(subscriber(), other.subscriber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteSubscriberRequest").add("AccountId", accountId()).add("BudgetName", budgetName())
                .add("Notification", notification()).add("Subscriber", subscriber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "BudgetName":
            return Optional.ofNullable(clazz.cast(budgetName()));
        case "Notification":
            return Optional.ofNullable(clazz.cast(notification()));
        case "Subscriber":
            return Optional.ofNullable(clazz.cast(subscriber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSubscriberRequest, T> g) {
        return obj -> g.apply((DeleteSubscriberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BudgetsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSubscriberRequest> {
        /**
         * <p>
         * The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.
         * </p>
         * 
         * @param accountId
         *        The <code>accountId</code> that is associated with the budget whose subscriber you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the budget whose subscriber you want to delete.
         * </p>
         * 
         * @param budgetName
         *        The name of the budget whose subscriber you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * <p>
         * The notification whose subscriber you want to delete.
         * </p>
         * 
         * @param notification
         *        The notification whose subscriber you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notification(Notification notification);

        /**
         * <p>
         * The notification whose subscriber you want to delete.
         * </p>
         * This is a convenience that creates an instance of the {@link Notification.Builder} avoiding the need to
         * create one manually via {@link Notification#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notification.Builder#build()} is called immediately and its
         * result is passed to {@link #notification(Notification)}.
         * 
         * @param notification
         *        a consumer that will call methods on {@link Notification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notification(Notification)
         */
        default Builder notification(Consumer<Notification.Builder> notification) {
            return notification(Notification.builder().applyMutation(notification).build());
        }

        /**
         * <p>
         * The subscriber that you want to delete.
         * </p>
         * 
         * @param subscriber
         *        The subscriber that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriber(Subscriber subscriber);

        /**
         * <p>
         * The subscriber that you want to delete.
         * </p>
         * This is a convenience that creates an instance of the {@link Subscriber.Builder} avoiding the need to create
         * one manually via {@link Subscriber#builder()}.
         *
         * When the {@link Consumer} completes, {@link Subscriber.Builder#build()} is called immediately and its result
         * is passed to {@link #subscriber(Subscriber)}.
         * 
         * @param subscriber
         *        a consumer that will call methods on {@link Subscriber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriber(Subscriber)
         */
        default Builder subscriber(Consumer<Subscriber.Builder> subscriber) {
            return subscriber(Subscriber.builder().applyMutation(subscriber).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BudgetsRequest.BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private Notification notification;

        private Subscriber subscriber;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSubscriberRequest model) {
            super(model);
            accountId(model.accountId);
            budgetName(model.budgetName);
            notification(model.notification);
            subscriber(model.subscriber);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification.Builder getNotification() {
            return notification != null ? notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final Subscriber.Builder getSubscriber() {
            return subscriber != null ? subscriber.toBuilder() : null;
        }

        @Override
        public final Builder subscriber(Subscriber subscriber) {
            this.subscriber = subscriber;
            return this;
        }

        public final void setSubscriber(Subscriber.BuilderImpl subscriber) {
            this.subscriber = subscriber != null ? subscriber.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSubscriberRequest build() {
            return new DeleteSubscriberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
