/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.budgets.model.BudgetsRequest;
import software.amazon.awssdk.services.budgets.model.Notification;
import software.amazon.awssdk.services.budgets.model.Subscriber;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateSubscriberRequest
extends BudgetsRequest
implements ToCopyableBuilder<Builder, CreateSubscriberRequest> {
    private final String accountId;
    private final String budgetName;
    private final Notification notification;
    private final Subscriber subscriber;

    private CreateSubscriberRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.notification = builder.notification;
        this.subscriber = builder.subscriber;
    }

    public String accountId() {
        return this.accountId;
    }

    public String budgetName() {
        return this.budgetName;
    }

    public Notification notification() {
        return this.notification;
    }

    public Subscriber subscriber() {
        return this.subscriber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriberRequest)) {
            return false;
        }
        CreateSubscriberRequest other = (CreateSubscriberRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.subscriber(), other.subscriber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.budgetName() != null) {
            sb.append("BudgetName: ").append(this.budgetName()).append(",");
        }
        if (this.notification() != null) {
            sb.append("Notification: ").append(this.notification()).append(",");
        }
        if (this.subscriber() != null) {
            sb.append("Subscriber: ").append(this.subscriber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "BudgetName": {
                return Optional.of(clazz.cast(this.budgetName()));
            }
            case "Notification": {
                return Optional.of(clazz.cast(this.notification()));
            }
            case "Subscriber": {
                return Optional.of(clazz.cast(this.subscriber()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BudgetsRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String budgetName;
        private Notification notification;
        private Subscriber subscriber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriberRequest model) {
            this.accountId(model.accountId);
            this.budgetName(model.budgetName);
            this.notification(model.notification);
            this.subscriber(model.subscriber);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final Subscriber.Builder getSubscriber() {
            return this.subscriber != null ? this.subscriber.toBuilder() : null;
        }

        @Override
        public final Builder subscriber(Subscriber subscriber) {
            this.subscriber = subscriber;
            return this;
        }

        public final void setSubscriber(Subscriber.BuilderImpl subscriber) {
            this.subscriber = subscriber != null ? subscriber.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriberRequest build() {
            return new CreateSubscriberRequest(this);
        }
    }

    public static interface Builder
    extends BudgetsRequest.Builder,
    CopyableBuilder<Builder, CreateSubscriberRequest> {
        public Builder accountId(String var1);

        public Builder budgetName(String var1);

        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().apply(notification)).build());
        }

        public Builder subscriber(Subscriber var1);

        default public Builder subscriber(Consumer<Subscriber.Builder> subscriber) {
            return this.subscriber((Subscriber)((Subscriber.Builder)Subscriber.builder().apply(subscriber)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

