/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.CalculatedSpend;

@SdkInternalApi
public class CalculatedSpendMarshaller {
    private static final MarshallingInfo<StructuredPojo> ACTUALSPEND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActualSpend").build();
    private static final MarshallingInfo<StructuredPojo> FORECASTEDSPEND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForecastedSpend").build();
    private static final CalculatedSpendMarshaller INSTANCE = new CalculatedSpendMarshaller();

    public static CalculatedSpendMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CalculatedSpend calculatedSpend, ProtocolMarshaller protocolMarshaller) {
        if (calculatedSpend == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)calculatedSpend.actualSpend(), ACTUALSPEND_BINDING);
            protocolMarshaller.marshall((Object)calculatedSpend.forecastedSpend(), FORECASTEDSPEND_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

