/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.budgets.model.Budget;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateBudgetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateBudgetRequest> {
    private final String accountId;
    private final Budget newBudget;

    private UpdateBudgetRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.newBudget = builder.newBudget;
    }

    public String accountId() {
        return this.accountId;
    }

    public Budget newBudget() {
        return this.newBudget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.newBudget() == null ? 0 : this.newBudget().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBudgetRequest)) {
            return false;
        }
        UpdateBudgetRequest other = (UpdateBudgetRequest)((Object)obj);
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.newBudget() == null ^ this.newBudget() == null) {
            return false;
        }
        return other.newBudget() == null || other.newBudget().equals(this.newBudget());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.newBudget() != null) {
            sb.append("NewBudget: ").append(this.newBudget()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
            case "NewBudget": {
                return Optional.of(clazz.cast(this.newBudget()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Budget newBudget;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBudgetRequest model) {
            this.accountId(model.accountId);
            this.newBudget(model.newBudget);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Budget.Builder getNewBudget() {
            return this.newBudget != null ? this.newBudget.toBuilder() : null;
        }

        @Override
        public final Builder newBudget(Budget newBudget) {
            this.newBudget = newBudget;
            return this;
        }

        public final void setNewBudget(Budget.BuilderImpl newBudget) {
            this.newBudget = newBudget != null ? newBudget.build() : null;
        }

        public UpdateBudgetRequest build() {
            return new UpdateBudgetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateBudgetRequest> {
        public Builder accountId(String var1);

        public Builder newBudget(Budget var1);
    }
}

