/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.budgets.model.Budget;
import software.amazon.awssdk.services.budgets.model.BudgetsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeBudgetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeBudgetsResponse> {
    private final List<Budget> budgets;
    private final String nextToken;

    private DescribeBudgetsResponse(BuilderImpl builder) {
        this.budgets = builder.budgets;
        this.nextToken = builder.nextToken;
    }

    public List<Budget> budgets() {
        return this.budgets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.budgets() == null ? 0 : this.budgets().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBudgetsResponse)) {
            return false;
        }
        DescribeBudgetsResponse other = (DescribeBudgetsResponse)((Object)obj);
        if (other.budgets() == null ^ this.budgets() == null) {
            return false;
        }
        if (other.budgets() != null && !other.budgets().equals(this.budgets())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.budgets() != null) {
            sb.append("Budgets: ").append(this.budgets()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Budget> budgets;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBudgetsResponse model) {
            this.setBudgets(model.budgets);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Budget> getBudgets() {
            return this.budgets;
        }

        @Override
        public final Builder budgets(Collection<Budget> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Budget ... budgets) {
            this.budgets(Arrays.asList(budgets));
            return this;
        }

        public final void setBudgets(Collection<Budget> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeBudgetsResponse build() {
            return new DescribeBudgetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeBudgetsResponse> {
        public Builder budgets(Collection<Budget> var1);

        public Builder budgets(Budget ... var1);

        public Builder nextToken(String var1);
    }
}

