/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.ComparisonOperator;
import software.amazon.awssdk.services.budgets.model.NotificationType;
import software.amazon.awssdk.services.budgets.transform.NotificationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Notification
implements StructuredPojo,
ToCopyableBuilder<Builder, Notification> {
    private final String notificationType;
    private final String comparisonOperator;
    private final Double threshold;

    private Notification(BuilderImpl builder) {
        this.notificationType = builder.notificationType;
        this.comparisonOperator = builder.comparisonOperator;
        this.threshold = builder.threshold;
    }

    public String notificationType() {
        return this.notificationType;
    }

    public String comparisonOperator() {
        return this.comparisonOperator;
    }

    public Double threshold() {
        return this.threshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.notificationType() == null ? 0 : this.notificationType().hashCode());
        hashCode = 31 * hashCode + (this.comparisonOperator() == null ? 0 : this.comparisonOperator().hashCode());
        hashCode = 31 * hashCode + (this.threshold() == null ? 0 : this.threshold().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)obj;
        if (other.notificationType() == null ^ this.notificationType() == null) {
            return false;
        }
        if (other.notificationType() != null && !other.notificationType().equals(this.notificationType())) {
            return false;
        }
        if (other.comparisonOperator() == null ^ this.comparisonOperator() == null) {
            return false;
        }
        if (other.comparisonOperator() != null && !other.comparisonOperator().equals(this.comparisonOperator())) {
            return false;
        }
        if (other.threshold() == null ^ this.threshold() == null) {
            return false;
        }
        return other.threshold() == null || other.threshold().equals(this.threshold());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.notificationType() != null) {
            sb.append("NotificationType: ").append(this.notificationType()).append(",");
        }
        if (this.comparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(this.comparisonOperator()).append(",");
        }
        if (this.threshold() != null) {
            sb.append("Threshold: ").append(this.threshold()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String notificationType;
        private String comparisonOperator;
        private Double threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(Notification model) {
            this.setNotificationType(model.notificationType);
            this.setComparisonOperator(model.comparisonOperator);
            this.setThreshold(model.threshold);
        }

        public final String getNotificationType() {
            return this.notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public Notification build() {
            return new Notification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Notification> {
        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder threshold(Double var1);
    }
}

