/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.budgets.model.Budget;
import software.amazon.awssdk.services.budgets.transform.CalculatedSpendUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.CostTypesUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.SpendUnmarshaller;
import software.amazon.awssdk.services.budgets.transform.TimePeriodUnmarshaller;

public class BudgetUnmarshaller
implements Unmarshaller<Budget, JsonUnmarshallerContext> {
    private static BudgetUnmarshaller INSTANCE;

    public Budget unmarshall(JsonUnmarshallerContext context) throws Exception {
        Budget.Builder budgetBuilder = Budget.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BudgetName", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.budgetName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BudgetLimit", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.budgetLimit(SpendUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CostFilters", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.costFilters(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("CostTypes", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.costTypes(CostTypesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("TimeUnit", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.timeUnit((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TimePeriod", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.timePeriod(TimePeriodUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("CalculatedSpend", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.calculatedSpend(CalculatedSpendUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("BudgetType", targetDepth)) {
                    context.nextToken();
                    budgetBuilder.budgetType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Budget)budgetBuilder.build();
    }

    public static BudgetUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BudgetUnmarshaller();
        }
        return INSTANCE;
    }
}

