/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.TimePeriod;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TimePeriodMarshaller {
    private static final MarshallingInfo<Instant> START_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Start").isBinary(false).build();
    private static final MarshallingInfo<Instant> END_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("End").isBinary(false).build();
    private static final TimePeriodMarshaller INSTANCE = new TimePeriodMarshaller();

    private TimePeriodMarshaller() {
    }

    public static TimePeriodMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TimePeriod timePeriod, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)timePeriod, (String)"timePeriod");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)timePeriod.start(), START_BINDING);
            protocolMarshaller.marshall((Object)timePeriod.end(), END_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

