/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers;

@SdkInternalApi
public class NotificationWithSubscribersMarshaller {
    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification").build();
    private static final MarshallingInfo<List> SUBSCRIBERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subscribers").build();
    private static final NotificationWithSubscribersMarshaller instance = new NotificationWithSubscribersMarshaller();

    public static NotificationWithSubscribersMarshaller getInstance() {
        return instance;
    }

    public void marshall(NotificationWithSubscribers notificationWithSubscribers, ProtocolMarshaller protocolMarshaller) {
        if (notificationWithSubscribers == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)notificationWithSubscribers.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall(notificationWithSubscribers.subscribers(), SUBSCRIBERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

