/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.braket.BraketClient;
import software.amazon.awssdk.services.braket.internal.UserAgentUtils;
import software.amazon.awssdk.services.braket.model.SearchSpendingLimitsRequest;
import software.amazon.awssdk.services.braket.model.SearchSpendingLimitsResponse;
import software.amazon.awssdk.services.braket.model.SpendingLimitSummary;

public class SearchSpendingLimitsIterable
implements SdkIterable<SearchSpendingLimitsResponse> {
    private final BraketClient client;
    private final SearchSpendingLimitsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchSpendingLimitsIterable(BraketClient client, SearchSpendingLimitsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchSpendingLimitsResponseFetcher();
    }

    public Iterator<SearchSpendingLimitsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SpendingLimitSummary> spendingLimits() {
        Function<SearchSpendingLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.spendingLimits() != null) {
                return response.spendingLimits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchSpendingLimitsResponseFetcher
    implements SyncPageFetcher<SearchSpendingLimitsResponse> {
        private SearchSpendingLimitsResponseFetcher() {
        }

        public boolean hasNextPage(SearchSpendingLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchSpendingLimitsResponse nextPage(SearchSpendingLimitsResponse previousPage) {
            if (previousPage == null) {
                return SearchSpendingLimitsIterable.this.client.searchSpendingLimits(SearchSpendingLimitsIterable.this.firstRequest);
            }
            return SearchSpendingLimitsIterable.this.client.searchSpendingLimits((SearchSpendingLimitsRequest)((Object)SearchSpendingLimitsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

