/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.braket.BraketAsyncClientBuilder;
import software.amazon.awssdk.services.braket.BraketServiceClientConfiguration;
import software.amazon.awssdk.services.braket.DefaultBraketAsyncClientBuilder;
import software.amazon.awssdk.services.braket.model.CancelJobRequest;
import software.amazon.awssdk.services.braket.model.CancelJobResponse;
import software.amazon.awssdk.services.braket.model.CancelQuantumTaskRequest;
import software.amazon.awssdk.services.braket.model.CancelQuantumTaskResponse;
import software.amazon.awssdk.services.braket.model.CreateJobRequest;
import software.amazon.awssdk.services.braket.model.CreateJobResponse;
import software.amazon.awssdk.services.braket.model.CreateQuantumTaskRequest;
import software.amazon.awssdk.services.braket.model.CreateQuantumTaskResponse;
import software.amazon.awssdk.services.braket.model.CreateSpendingLimitRequest;
import software.amazon.awssdk.services.braket.model.CreateSpendingLimitResponse;
import software.amazon.awssdk.services.braket.model.DeleteSpendingLimitRequest;
import software.amazon.awssdk.services.braket.model.DeleteSpendingLimitResponse;
import software.amazon.awssdk.services.braket.model.GetDeviceRequest;
import software.amazon.awssdk.services.braket.model.GetDeviceResponse;
import software.amazon.awssdk.services.braket.model.GetJobRequest;
import software.amazon.awssdk.services.braket.model.GetJobResponse;
import software.amazon.awssdk.services.braket.model.GetQuantumTaskRequest;
import software.amazon.awssdk.services.braket.model.GetQuantumTaskResponse;
import software.amazon.awssdk.services.braket.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.braket.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.braket.model.SearchDevicesRequest;
import software.amazon.awssdk.services.braket.model.SearchDevicesResponse;
import software.amazon.awssdk.services.braket.model.SearchJobsRequest;
import software.amazon.awssdk.services.braket.model.SearchJobsResponse;
import software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest;
import software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse;
import software.amazon.awssdk.services.braket.model.SearchSpendingLimitsRequest;
import software.amazon.awssdk.services.braket.model.SearchSpendingLimitsResponse;
import software.amazon.awssdk.services.braket.model.TagResourceRequest;
import software.amazon.awssdk.services.braket.model.TagResourceResponse;
import software.amazon.awssdk.services.braket.model.UntagResourceRequest;
import software.amazon.awssdk.services.braket.model.UntagResourceResponse;
import software.amazon.awssdk.services.braket.model.UpdateSpendingLimitRequest;
import software.amazon.awssdk.services.braket.model.UpdateSpendingLimitResponse;
import software.amazon.awssdk.services.braket.paginators.SearchDevicesPublisher;
import software.amazon.awssdk.services.braket.paginators.SearchJobsPublisher;
import software.amazon.awssdk.services.braket.paginators.SearchQuantumTasksPublisher;
import software.amazon.awssdk.services.braket.paginators.SearchSpendingLimitsPublisher;

@SdkPublicApi
@ThreadSafe
public interface BraketAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "braket";
    public static final String SERVICE_METADATA_ID = "braket";

    default public CompletableFuture<CancelJobResponse> cancelJob(CancelJobRequest cancelJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CancelJobResponse> cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) {
        return this.cancelJob((CancelJobRequest)((Object)((CancelJobRequest.Builder)CancelJobRequest.builder().applyMutation(cancelJobRequest)).build()));
    }

    default public CompletableFuture<CancelQuantumTaskResponse> cancelQuantumTask(CancelQuantumTaskRequest cancelQuantumTaskRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CancelQuantumTaskResponse> cancelQuantumTask(Consumer<CancelQuantumTaskRequest.Builder> cancelQuantumTaskRequest) {
        return this.cancelQuantumTask((CancelQuantumTaskRequest)((Object)((CancelQuantumTaskRequest.Builder)CancelQuantumTaskRequest.builder().applyMutation(cancelQuantumTaskRequest)).build()));
    }

    default public CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateJobResponse> createJob(Consumer<CreateJobRequest.Builder> createJobRequest) {
        return this.createJob((CreateJobRequest)((Object)((CreateJobRequest.Builder)CreateJobRequest.builder().applyMutation(createJobRequest)).build()));
    }

    default public CompletableFuture<CreateQuantumTaskResponse> createQuantumTask(CreateQuantumTaskRequest createQuantumTaskRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateQuantumTaskResponse> createQuantumTask(Consumer<CreateQuantumTaskRequest.Builder> createQuantumTaskRequest) {
        return this.createQuantumTask((CreateQuantumTaskRequest)((Object)((CreateQuantumTaskRequest.Builder)CreateQuantumTaskRequest.builder().applyMutation(createQuantumTaskRequest)).build()));
    }

    default public CompletableFuture<CreateSpendingLimitResponse> createSpendingLimit(CreateSpendingLimitRequest createSpendingLimitRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateSpendingLimitResponse> createSpendingLimit(Consumer<CreateSpendingLimitRequest.Builder> createSpendingLimitRequest) {
        return this.createSpendingLimit((CreateSpendingLimitRequest)((Object)((CreateSpendingLimitRequest.Builder)CreateSpendingLimitRequest.builder().applyMutation(createSpendingLimitRequest)).build()));
    }

    default public CompletableFuture<DeleteSpendingLimitResponse> deleteSpendingLimit(DeleteSpendingLimitRequest deleteSpendingLimitRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteSpendingLimitResponse> deleteSpendingLimit(Consumer<DeleteSpendingLimitRequest.Builder> deleteSpendingLimitRequest) {
        return this.deleteSpendingLimit((DeleteSpendingLimitRequest)((Object)((DeleteSpendingLimitRequest.Builder)DeleteSpendingLimitRequest.builder().applyMutation(deleteSpendingLimitRequest)).build()));
    }

    default public CompletableFuture<GetDeviceResponse> getDevice(GetDeviceRequest getDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetDeviceResponse> getDevice(Consumer<GetDeviceRequest.Builder> getDeviceRequest) {
        return this.getDevice((GetDeviceRequest)((Object)((GetDeviceRequest.Builder)GetDeviceRequest.builder().applyMutation(getDeviceRequest)).build()));
    }

    default public CompletableFuture<GetJobResponse> getJob(GetJobRequest getJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetJobResponse> getJob(Consumer<GetJobRequest.Builder> getJobRequest) {
        return this.getJob((GetJobRequest)((Object)((GetJobRequest.Builder)GetJobRequest.builder().applyMutation(getJobRequest)).build()));
    }

    default public CompletableFuture<GetQuantumTaskResponse> getQuantumTask(GetQuantumTaskRequest getQuantumTaskRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetQuantumTaskResponse> getQuantumTask(Consumer<GetQuantumTaskRequest.Builder> getQuantumTaskRequest) {
        return this.getQuantumTask((GetQuantumTaskRequest)((Object)((GetQuantumTaskRequest.Builder)GetQuantumTaskRequest.builder().applyMutation(getQuantumTaskRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<SearchDevicesResponse> searchDevices(SearchDevicesRequest searchDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SearchDevicesResponse> searchDevices(Consumer<SearchDevicesRequest.Builder> searchDevicesRequest) {
        return this.searchDevices((SearchDevicesRequest)((Object)((SearchDevicesRequest.Builder)SearchDevicesRequest.builder().applyMutation(searchDevicesRequest)).build()));
    }

    default public SearchDevicesPublisher searchDevicesPaginator(SearchDevicesRequest searchDevicesRequest) {
        return new SearchDevicesPublisher(this, searchDevicesRequest);
    }

    default public SearchDevicesPublisher searchDevicesPaginator(Consumer<SearchDevicesRequest.Builder> searchDevicesRequest) {
        return this.searchDevicesPaginator((SearchDevicesRequest)((Object)((SearchDevicesRequest.Builder)SearchDevicesRequest.builder().applyMutation(searchDevicesRequest)).build()));
    }

    default public CompletableFuture<SearchJobsResponse> searchJobs(SearchJobsRequest searchJobsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SearchJobsResponse> searchJobs(Consumer<SearchJobsRequest.Builder> searchJobsRequest) {
        return this.searchJobs((SearchJobsRequest)((Object)((SearchJobsRequest.Builder)SearchJobsRequest.builder().applyMutation(searchJobsRequest)).build()));
    }

    default public SearchJobsPublisher searchJobsPaginator(SearchJobsRequest searchJobsRequest) {
        return new SearchJobsPublisher(this, searchJobsRequest);
    }

    default public SearchJobsPublisher searchJobsPaginator(Consumer<SearchJobsRequest.Builder> searchJobsRequest) {
        return this.searchJobsPaginator((SearchJobsRequest)((Object)((SearchJobsRequest.Builder)SearchJobsRequest.builder().applyMutation(searchJobsRequest)).build()));
    }

    default public CompletableFuture<SearchQuantumTasksResponse> searchQuantumTasks(SearchQuantumTasksRequest searchQuantumTasksRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SearchQuantumTasksResponse> searchQuantumTasks(Consumer<SearchQuantumTasksRequest.Builder> searchQuantumTasksRequest) {
        return this.searchQuantumTasks((SearchQuantumTasksRequest)((Object)((SearchQuantumTasksRequest.Builder)SearchQuantumTasksRequest.builder().applyMutation(searchQuantumTasksRequest)).build()));
    }

    default public SearchQuantumTasksPublisher searchQuantumTasksPaginator(SearchQuantumTasksRequest searchQuantumTasksRequest) {
        return new SearchQuantumTasksPublisher(this, searchQuantumTasksRequest);
    }

    default public SearchQuantumTasksPublisher searchQuantumTasksPaginator(Consumer<SearchQuantumTasksRequest.Builder> searchQuantumTasksRequest) {
        return this.searchQuantumTasksPaginator((SearchQuantumTasksRequest)((Object)((SearchQuantumTasksRequest.Builder)SearchQuantumTasksRequest.builder().applyMutation(searchQuantumTasksRequest)).build()));
    }

    default public CompletableFuture<SearchSpendingLimitsResponse> searchSpendingLimits(SearchSpendingLimitsRequest searchSpendingLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<SearchSpendingLimitsResponse> searchSpendingLimits(Consumer<SearchSpendingLimitsRequest.Builder> searchSpendingLimitsRequest) {
        return this.searchSpendingLimits((SearchSpendingLimitsRequest)((Object)((SearchSpendingLimitsRequest.Builder)SearchSpendingLimitsRequest.builder().applyMutation(searchSpendingLimitsRequest)).build()));
    }

    default public SearchSpendingLimitsPublisher searchSpendingLimitsPaginator(SearchSpendingLimitsRequest searchSpendingLimitsRequest) {
        return new SearchSpendingLimitsPublisher(this, searchSpendingLimitsRequest);
    }

    default public SearchSpendingLimitsPublisher searchSpendingLimitsPaginator(Consumer<SearchSpendingLimitsRequest.Builder> searchSpendingLimitsRequest) {
        return this.searchSpendingLimitsPaginator((SearchSpendingLimitsRequest)((Object)((SearchSpendingLimitsRequest.Builder)SearchSpendingLimitsRequest.builder().applyMutation(searchSpendingLimitsRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public CompletableFuture<UpdateSpendingLimitResponse> updateSpendingLimit(UpdateSpendingLimitRequest updateSpendingLimitRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateSpendingLimitResponse> updateSpendingLimit(Consumer<UpdateSpendingLimitRequest.Builder> updateSpendingLimitRequest) {
        return this.updateSpendingLimit((UpdateSpendingLimitRequest)((Object)((UpdateSpendingLimitRequest.Builder)UpdateSpendingLimitRequest.builder().applyMutation(updateSpendingLimitRequest)).build()));
    }

    default public BraketServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static BraketAsyncClient create() {
        return (BraketAsyncClient)BraketAsyncClient.builder().build();
    }

    public static BraketAsyncClientBuilder builder() {
        return new DefaultBraketAsyncClientBuilder();
    }
}

