/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.QueueName;
import software.amazon.awssdk.services.braket.model.QueuePriority;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceQueueInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceQueueInfo> {
    private static final SdkField<String> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queue").getter(DeviceQueueInfo.getter(DeviceQueueInfo::queueAsString)).setter(DeviceQueueInfo.setter(Builder::queue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()}).build();
    private static final SdkField<String> QUEUE_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queuePriority").getter(DeviceQueueInfo.getter(DeviceQueueInfo::queuePriorityAsString)).setter(DeviceQueueInfo.setter(Builder::queuePriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuePriority").build()}).build();
    private static final SdkField<String> QUEUE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueSize").getter(DeviceQueueInfo.getter(DeviceQueueInfo::queueSize)).setter(DeviceQueueInfo.setter(Builder::queueSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_FIELD, QUEUE_PRIORITY_FIELD, QUEUE_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeviceQueueInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queue;
    private final String queuePriority;
    private final String queueSize;

    private DeviceQueueInfo(BuilderImpl builder) {
        this.queue = builder.queue;
        this.queuePriority = builder.queuePriority;
        this.queueSize = builder.queueSize;
    }

    public final QueueName queue() {
        return QueueName.fromValue(this.queue);
    }

    public final String queueAsString() {
        return this.queue;
    }

    public final QueuePriority queuePriority() {
        return QueuePriority.fromValue(this.queuePriority);
    }

    public final String queuePriorityAsString() {
        return this.queuePriority;
    }

    public final String queueSize() {
        return this.queueSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuePriorityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceQueueInfo)) {
            return false;
        }
        DeviceQueueInfo other = (DeviceQueueInfo)obj;
        return Objects.equals(this.queueAsString(), other.queueAsString()) && Objects.equals(this.queuePriorityAsString(), other.queuePriorityAsString()) && Objects.equals(this.queueSize(), other.queueSize());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceQueueInfo").add("Queue", (Object)this.queueAsString()).add("QueuePriority", (Object)this.queuePriorityAsString()).add("QueueSize", (Object)this.queueSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queue": {
                return Optional.ofNullable(clazz.cast(this.queueAsString()));
            }
            case "queuePriority": {
                return Optional.ofNullable(clazz.cast(this.queuePriorityAsString()));
            }
            case "queueSize": {
                return Optional.ofNullable(clazz.cast(this.queueSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("queue", QUEUE_FIELD);
        map.put("queuePriority", QUEUE_PRIORITY_FIELD);
        map.put("queueSize", QUEUE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceQueueInfo, T> g) {
        return obj -> g.apply((DeviceQueueInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queue;
        private String queuePriority;
        private String queueSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceQueueInfo model) {
            this.queue(model.queue);
            this.queuePriority(model.queuePriority);
            this.queueSize(model.queueSize);
        }

        public final String getQueue() {
            return this.queue;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        @Override
        public final Builder queue(QueueName queue) {
            this.queue(queue == null ? null : queue.toString());
            return this;
        }

        public final String getQueuePriority() {
            return this.queuePriority;
        }

        public final void setQueuePriority(String queuePriority) {
            this.queuePriority = queuePriority;
        }

        @Override
        public final Builder queuePriority(String queuePriority) {
            this.queuePriority = queuePriority;
            return this;
        }

        @Override
        public final Builder queuePriority(QueuePriority queuePriority) {
            this.queuePriority(queuePriority == null ? null : queuePriority.toString());
            return this;
        }

        public final String getQueueSize() {
            return this.queueSize;
        }

        public final void setQueueSize(String queueSize) {
            this.queueSize = queueSize;
        }

        @Override
        public final Builder queueSize(String queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public DeviceQueueInfo build() {
            return new DeviceQueueInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceQueueInfo> {
        public Builder queue(String var1);

        public Builder queue(QueueName var1);

        public Builder queuePriority(String var1);

        public Builder queuePriority(QueuePriority var1);

        public Builder queueSize(String var1);
    }
}

