/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.QueueName;
import software.amazon.awssdk.services.braket.model.QueuePriority;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuantumTaskQueueInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuantumTaskQueueInfo> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(QuantumTaskQueueInfo.getter(QuantumTaskQueueInfo::message)).setter(QuantumTaskQueueInfo.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("position").getter(QuantumTaskQueueInfo.getter(QuantumTaskQueueInfo::position)).setter(QuantumTaskQueueInfo.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<String> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queue").getter(QuantumTaskQueueInfo.getter(QuantumTaskQueueInfo::queueAsString)).setter(QuantumTaskQueueInfo.setter(Builder::queue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()}).build();
    private static final SdkField<String> QUEUE_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queuePriority").getter(QuantumTaskQueueInfo.getter(QuantumTaskQueueInfo::queuePriorityAsString)).setter(QuantumTaskQueueInfo.setter(Builder::queuePriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuePriority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, POSITION_FIELD, QUEUE_FIELD, QUEUE_PRIORITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QuantumTaskQueueInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String message;
    private final String position;
    private final String queue;
    private final String queuePriority;

    private QuantumTaskQueueInfo(BuilderImpl builder) {
        this.message = builder.message;
        this.position = builder.position;
        this.queue = builder.queue;
        this.queuePriority = builder.queuePriority;
    }

    public final String message() {
        return this.message;
    }

    public final String position() {
        return this.position;
    }

    public final QueueName queue() {
        return QueueName.fromValue(this.queue);
    }

    public final String queueAsString() {
        return this.queue;
    }

    public final QueuePriority queuePriority() {
        return QueuePriority.fromValue(this.queuePriority);
    }

    public final String queuePriorityAsString() {
        return this.queuePriority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuePriorityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuantumTaskQueueInfo)) {
            return false;
        }
        QuantumTaskQueueInfo other = (QuantumTaskQueueInfo)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.queueAsString(), other.queueAsString()) && Objects.equals(this.queuePriorityAsString(), other.queuePriorityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"QuantumTaskQueueInfo").add("Message", (Object)this.message()).add("Position", (Object)this.position()).add("Queue", (Object)this.queueAsString()).add("QueuePriority", (Object)this.queuePriorityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "queue": {
                return Optional.ofNullable(clazz.cast(this.queueAsString()));
            }
            case "queuePriority": {
                return Optional.ofNullable(clazz.cast(this.queuePriorityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("message", MESSAGE_FIELD);
        map.put("position", POSITION_FIELD);
        map.put("queue", QUEUE_FIELD);
        map.put("queuePriority", QUEUE_PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuantumTaskQueueInfo, T> g) {
        return obj -> g.apply((QuantumTaskQueueInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private String position;
        private String queue;
        private String queuePriority;

        private BuilderImpl() {
        }

        private BuilderImpl(QuantumTaskQueueInfo model) {
            this.message(model.message);
            this.position(model.position);
            this.queue(model.queue);
            this.queuePriority(model.queuePriority);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getPosition() {
            return this.position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final String getQueue() {
            return this.queue;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        @Override
        public final Builder queue(QueueName queue) {
            this.queue(queue == null ? null : queue.toString());
            return this;
        }

        public final String getQueuePriority() {
            return this.queuePriority;
        }

        public final void setQueuePriority(String queuePriority) {
            this.queuePriority = queuePriority;
        }

        @Override
        public final Builder queuePriority(String queuePriority) {
            this.queuePriority = queuePriority;
            return this;
        }

        @Override
        public final Builder queuePriority(QueuePriority queuePriority) {
            this.queuePriority(queuePriority == null ? null : queuePriority.toString());
            return this;
        }

        public QuantumTaskQueueInfo build() {
            return new QuantumTaskQueueInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuantumTaskQueueInfo> {
        public Builder message(String var1);

        public Builder position(String var1);

        public Builder queue(String var1);

        public Builder queue(QueueName var1);

        public Builder queuePriority(String var1);

        public Builder queuePriority(QueuePriority var1);
    }
}

