/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.InstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceConfig> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("instanceCount").getter(InstanceConfig.getter(InstanceConfig::instanceCount)).setter(InstanceConfig.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceCount").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(InstanceConfig.getter(InstanceConfig::instanceTypeAsString)).setter(InstanceConfig.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("volumeSizeInGb").getter(InstanceConfig.getter(InstanceConfig::volumeSizeInGb)).setter(InstanceConfig.setter(Builder::volumeSizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSizeInGb").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD, INSTANCE_TYPE_FIELD, VOLUME_SIZE_IN_GB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer instanceCount;
    private final String instanceType;
    private final Integer volumeSizeInGb;

    private InstanceConfig(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.volumeSizeInGb = builder.volumeSizeInGb;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer volumeSizeInGb() {
        return this.volumeSizeInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGb());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceConfig)) {
            return false;
        }
        InstanceConfig other = (InstanceConfig)obj;
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.volumeSizeInGb(), other.volumeSizeInGb());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceConfig").add("InstanceCount", (Object)this.instanceCount()).add("InstanceType", (Object)this.instanceTypeAsString()).add("VolumeSizeInGb", (Object)this.volumeSizeInGb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "volumeSizeInGb": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGb()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceCount", INSTANCE_COUNT_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("volumeSizeInGb", VOLUME_SIZE_IN_GB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceConfig, T> g) {
        return obj -> g.apply((InstanceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String instanceType;
        private Integer volumeSizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceConfig model) {
            this.instanceCount(model.instanceCount);
            this.instanceType(model.instanceType);
            this.volumeSizeInGb(model.volumeSizeInGb);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getVolumeSizeInGb() {
            return this.volumeSizeInGb;
        }

        public final void setVolumeSizeInGb(Integer volumeSizeInGb) {
            this.volumeSizeInGb = volumeSizeInGb;
        }

        @Override
        public final Builder volumeSizeInGb(Integer volumeSizeInGb) {
            this.volumeSizeInGb = volumeSizeInGb;
            return this;
        }

        public InstanceConfig build() {
            return new InstanceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceConfig> {
        public Builder instanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder volumeSizeInGb(Integer var1);
    }
}

