/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.braket.BraketAsyncClient;
import software.amazon.awssdk.services.braket.internal.UserAgentUtils;
import software.amazon.awssdk.services.braket.model.DeviceSummary;
import software.amazon.awssdk.services.braket.model.SearchDevicesRequest;
import software.amazon.awssdk.services.braket.model.SearchDevicesResponse;

public class SearchDevicesPublisher
implements SdkPublisher<SearchDevicesResponse> {
    private final BraketAsyncClient client;
    private final SearchDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchDevicesPublisher(BraketAsyncClient client, SearchDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchDevicesPublisher(BraketAsyncClient client, SearchDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeviceSummary> devices() {
        Function<SearchDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.devices() != null) {
                return response.devices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchDevicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchDevicesResponseFetcher
    implements AsyncPageFetcher<SearchDevicesResponse> {
        private SearchDevicesResponseFetcher() {
        }

        public boolean hasNextPage(SearchDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchDevicesResponse> nextPage(SearchDevicesResponse previousPage) {
            if (previousPage == null) {
                return SearchDevicesPublisher.this.client.searchDevices(SearchDevicesPublisher.this.firstRequest);
            }
            return SearchDevicesPublisher.this.client.searchDevices((SearchDevicesRequest)((Object)SearchDevicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

