/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.BraketResponse;
import software.amazon.awssdk.services.braket.model.CancellationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelQuantumTaskResponse
extends BraketResponse
implements ToCopyableBuilder<Builder, CancelQuantumTaskResponse> {
    private static final SdkField<String> CANCELLATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cancellationStatus").getter(CancelQuantumTaskResponse.getter(CancelQuantumTaskResponse::cancellationStatusAsString)).setter(CancelQuantumTaskResponse.setter(Builder::cancellationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancellationStatus").build()}).build();
    private static final SdkField<String> QUANTUM_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quantumTaskArn").getter(CancelQuantumTaskResponse.getter(CancelQuantumTaskResponse::quantumTaskArn)).setter(CancelQuantumTaskResponse.setter(Builder::quantumTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantumTaskArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCELLATION_STATUS_FIELD, QUANTUM_TASK_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cancellationStatus", CANCELLATION_STATUS_FIELD);
            this.put("quantumTaskArn", QUANTUM_TASK_ARN_FIELD);
        }
    });
    private final String cancellationStatus;
    private final String quantumTaskArn;

    private CancelQuantumTaskResponse(BuilderImpl builder) {
        super(builder);
        this.cancellationStatus = builder.cancellationStatus;
        this.quantumTaskArn = builder.quantumTaskArn;
    }

    public final CancellationStatus cancellationStatus() {
        return CancellationStatus.fromValue(this.cancellationStatus);
    }

    public final String cancellationStatusAsString() {
        return this.cancellationStatus;
    }

    public final String quantumTaskArn() {
        return this.quantumTaskArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cancellationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantumTaskArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelQuantumTaskResponse)) {
            return false;
        }
        CancelQuantumTaskResponse other = (CancelQuantumTaskResponse)((Object)obj);
        return Objects.equals(this.cancellationStatusAsString(), other.cancellationStatusAsString()) && Objects.equals(this.quantumTaskArn(), other.quantumTaskArn());
    }

    public final String toString() {
        return ToString.builder((String)"CancelQuantumTaskResponse").add("CancellationStatus", (Object)this.cancellationStatusAsString()).add("QuantumTaskArn", (Object)this.quantumTaskArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cancellationStatus": {
                return Optional.ofNullable(clazz.cast(this.cancellationStatusAsString()));
            }
            case "quantumTaskArn": {
                return Optional.ofNullable(clazz.cast(this.quantumTaskArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CancelQuantumTaskResponse, T> g) {
        return obj -> g.apply((CancelQuantumTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketResponse.BuilderImpl
    implements Builder {
        private String cancellationStatus;
        private String quantumTaskArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelQuantumTaskResponse model) {
            super(model);
            this.cancellationStatus(model.cancellationStatus);
            this.quantumTaskArn(model.quantumTaskArn);
        }

        public final String getCancellationStatus() {
            return this.cancellationStatus;
        }

        public final void setCancellationStatus(String cancellationStatus) {
            this.cancellationStatus = cancellationStatus;
        }

        @Override
        public final Builder cancellationStatus(String cancellationStatus) {
            this.cancellationStatus = cancellationStatus;
            return this;
        }

        @Override
        public final Builder cancellationStatus(CancellationStatus cancellationStatus) {
            this.cancellationStatus(cancellationStatus == null ? null : cancellationStatus.toString());
            return this;
        }

        public final String getQuantumTaskArn() {
            return this.quantumTaskArn;
        }

        public final void setQuantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
        }

        @Override
        public final Builder quantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
            return this;
        }

        @Override
        public CancelQuantumTaskResponse build() {
            return new CancelQuantumTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BraketResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelQuantumTaskResponse> {
        public Builder cancellationStatus(String var1);

        public Builder cancellationStatus(CancellationStatus var1);

        public Builder quantumTaskArn(String var1);
    }
}

