/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.braket.BraketAsyncClient;
import software.amazon.awssdk.services.braket.model.JobSummary;
import software.amazon.awssdk.services.braket.model.SearchJobsRequest;
import software.amazon.awssdk.services.braket.model.SearchJobsResponse;

public class SearchJobsPublisher
implements SdkPublisher<SearchJobsResponse> {
    private final BraketAsyncClient client;
    private final SearchJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchJobsPublisher(BraketAsyncClient client, SearchJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchJobsPublisher(BraketAsyncClient client, SearchJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobSummary> jobs() {
        Function<SearchJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchJobsResponseFetcher
    implements AsyncPageFetcher<SearchJobsResponse> {
        private SearchJobsResponseFetcher() {
        }

        public boolean hasNextPage(SearchJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchJobsResponse> nextPage(SearchJobsResponse previousPage) {
            if (previousPage == null) {
                return SearchJobsPublisher.this.client.searchJobs(SearchJobsPublisher.this.firstRequest);
            }
            return SearchJobsPublisher.this.client.searchJobs((SearchJobsRequest)((Object)SearchJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

