/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.braket.model.BraketResponse;
import software.amazon.awssdk.services.braket.model.QuantumTaskStatus;
import software.amazon.awssdk.services.braket.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQuantumTaskResponse
extends BraketResponse
implements ToCopyableBuilder<Builder, GetQuantumTaskResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetQuantumTaskResponse.getter(GetQuantumTaskResponse::createdAt)).setter(GetQuantumTaskResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceArn").getter(GetQuantumTaskResponse.getter(GetQuantumTaskResponse::deviceArn)).setter(GetQuantumTaskResponse.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()}).build();
    private static final SdkField<String> DEVICE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceParameters").getter(GetQuantumTaskResponse.getter(GetQuantumTaskResponse::deviceParameters)).setter(GetQuantumTaskResponse.setter(Builder::deviceParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceParameters").build(), JsonValueTrait.create()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(GetQuantumTaskResponse.getter(GetQuantumTaskResponse::endedAt)).setter(GetQuantumTaskResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(GetQuantumTaskResponse.getter(GetQuantumTaskResponse::failureReason)).setter(GetQuantumTaskResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> OUTPUT_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputS3Bucket").getter(GetQuantumTaskResponse.getter(GetQuantumTaskResponse::outputS3Bucket)).setter(GetQuantumTaskResponse.setter(Builder::outputS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Bucket").build()}).build();
    private static final SdkField<String> OUTPUT_S3_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputS3Directory").getter(GetQuantumTaskResponse.getter(GetQuantumTaskResponse::outputS3Directory)).setter(GetQuantumTaskResponse.setter(Builder::outputS3Directory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Directory").build()}).build();
    private static final SdkField<String> QUANTUM_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quantumTaskArn").getter(GetQuantumTaskResponse.getter(GetQuantumTaskResponse::quantumTaskArn)).setter(GetQuantumTaskResponse.setter(Builder::quantumTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantumTaskArn").build()}).build();
    private static final SdkField<Long> SHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("shots").getter(GetQuantumTaskResponse.getter(GetQuantumTaskResponse::shots)).setter(GetQuantumTaskResponse.setter(Builder::shots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shots").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetQuantumTaskResponse.getter(GetQuantumTaskResponse::statusAsString)).setter(GetQuantumTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetQuantumTaskResponse.getter(GetQuantumTaskResponse::tags)).setter(GetQuantumTaskResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DEVICE_ARN_FIELD, DEVICE_PARAMETERS_FIELD, ENDED_AT_FIELD, FAILURE_REASON_FIELD, OUTPUT_S3_BUCKET_FIELD, OUTPUT_S3_DIRECTORY_FIELD, QUANTUM_TASK_ARN_FIELD, SHOTS_FIELD, STATUS_FIELD, TAGS_FIELD));
    private final Instant createdAt;
    private final String deviceArn;
    private final String deviceParameters;
    private final Instant endedAt;
    private final String failureReason;
    private final String outputS3Bucket;
    private final String outputS3Directory;
    private final String quantumTaskArn;
    private final Long shots;
    private final String status;
    private final Map<String, String> tags;

    private GetQuantumTaskResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.deviceArn = builder.deviceArn;
        this.deviceParameters = builder.deviceParameters;
        this.endedAt = builder.endedAt;
        this.failureReason = builder.failureReason;
        this.outputS3Bucket = builder.outputS3Bucket;
        this.outputS3Directory = builder.outputS3Directory;
        this.quantumTaskArn = builder.quantumTaskArn;
        this.shots = builder.shots;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public String deviceParameters() {
        return this.deviceParameters;
    }

    public Instant endedAt() {
        return this.endedAt;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String outputS3Bucket() {
        return this.outputS3Bucket;
    }

    public String outputS3Directory() {
        return this.outputS3Directory;
    }

    public String quantumTaskArn() {
        return this.quantumTaskArn;
    }

    public Long shots() {
        return this.shots;
    }

    public QuantumTaskStatus status() {
        return QuantumTaskStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Directory());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantumTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.shots());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQuantumTaskResponse)) {
            return false;
        }
        GetQuantumTaskResponse other = (GetQuantumTaskResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.deviceParameters(), other.deviceParameters()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.outputS3Bucket(), other.outputS3Bucket()) && Objects.equals(this.outputS3Directory(), other.outputS3Directory()) && Objects.equals(this.quantumTaskArn(), other.quantumTaskArn()) && Objects.equals(this.shots(), other.shots()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetQuantumTaskResponse").add("CreatedAt", (Object)this.createdAt()).add("DeviceArn", (Object)this.deviceArn()).add("DeviceParameters", (Object)this.deviceParameters()).add("EndedAt", (Object)this.endedAt()).add("FailureReason", (Object)this.failureReason()).add("OutputS3Bucket", (Object)this.outputS3Bucket()).add("OutputS3Directory", (Object)this.outputS3Directory()).add("QuantumTaskArn", (Object)this.quantumTaskArn()).add("Shots", (Object)this.shots()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "deviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "deviceParameters": {
                return Optional.ofNullable(clazz.cast(this.deviceParameters()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "outputS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.outputS3Bucket()));
            }
            case "outputS3Directory": {
                return Optional.ofNullable(clazz.cast(this.outputS3Directory()));
            }
            case "quantumTaskArn": {
                return Optional.ofNullable(clazz.cast(this.quantumTaskArn()));
            }
            case "shots": {
                return Optional.ofNullable(clazz.cast(this.shots()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQuantumTaskResponse, T> g) {
        return obj -> g.apply((GetQuantumTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String deviceArn;
        private String deviceParameters;
        private Instant endedAt;
        private String failureReason;
        private String outputS3Bucket;
        private String outputS3Directory;
        private String quantumTaskArn;
        private Long shots;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQuantumTaskResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.deviceArn(model.deviceArn);
            this.deviceParameters(model.deviceParameters);
            this.endedAt(model.endedAt);
            this.failureReason(model.failureReason);
            this.outputS3Bucket(model.outputS3Bucket);
            this.outputS3Directory(model.outputS3Directory);
            this.quantumTaskArn(model.quantumTaskArn);
            this.shots(model.shots);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDeviceParameters() {
            return this.deviceParameters;
        }

        @Override
        public final Builder deviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
            return this;
        }

        public final void setDeviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getOutputS3Bucket() {
            return this.outputS3Bucket;
        }

        @Override
        public final Builder outputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
            return this;
        }

        public final void setOutputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
        }

        public final String getOutputS3Directory() {
            return this.outputS3Directory;
        }

        @Override
        public final Builder outputS3Directory(String outputS3Directory) {
            this.outputS3Directory = outputS3Directory;
            return this;
        }

        public final void setOutputS3Directory(String outputS3Directory) {
            this.outputS3Directory = outputS3Directory;
        }

        public final String getQuantumTaskArn() {
            return this.quantumTaskArn;
        }

        @Override
        public final Builder quantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
            return this;
        }

        public final void setQuantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
        }

        public final Long getShots() {
            return this.shots;
        }

        @Override
        public final Builder shots(Long shots) {
            this.shots = shots;
            return this;
        }

        public final void setShots(Long shots) {
            this.shots = shots;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QuantumTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public GetQuantumTaskResponse build() {
            return new GetQuantumTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BraketResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQuantumTaskResponse> {
        public Builder createdAt(Instant var1);

        public Builder deviceArn(String var1);

        public Builder deviceParameters(String var1);

        public Builder endedAt(Instant var1);

        public Builder failureReason(String var1);

        public Builder outputS3Bucket(String var1);

        public Builder outputS3Directory(String var1);

        public Builder quantumTaskArn(String var1);

        public Builder shots(Long var1);

        public Builder status(String var1);

        public Builder status(QuantumTaskStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

