/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.BraketResponse;
import software.amazon.awssdk.services.braket.model.DeviceStatus;
import software.amazon.awssdk.services.braket.model.DeviceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeviceResponse
extends BraketResponse
implements ToCopyableBuilder<Builder, GetDeviceResponse> {
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceArn").getter(GetDeviceResponse.getter(GetDeviceResponse::deviceArn)).setter(GetDeviceResponse.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()}).build();
    private static final SdkField<String> DEVICE_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceCapabilities").getter(GetDeviceResponse.getter(GetDeviceResponse::deviceCapabilities)).setter(GetDeviceResponse.setter(Builder::deviceCapabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCapabilities").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceName").getter(GetDeviceResponse.getter(GetDeviceResponse::deviceName)).setter(GetDeviceResponse.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceName").build()}).build();
    private static final SdkField<String> DEVICE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceStatus").getter(GetDeviceResponse.getter(GetDeviceResponse::deviceStatusAsString)).setter(GetDeviceResponse.setter(Builder::deviceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceStatus").build()}).build();
    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceType").getter(GetDeviceResponse.getter(GetDeviceResponse::deviceTypeAsString)).setter(GetDeviceResponse.setter(Builder::deviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceType").build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(GetDeviceResponse.getter(GetDeviceResponse::providerName)).setter(GetDeviceResponse.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ARN_FIELD, DEVICE_CAPABILITIES_FIELD, DEVICE_NAME_FIELD, DEVICE_STATUS_FIELD, DEVICE_TYPE_FIELD, PROVIDER_NAME_FIELD));
    private final String deviceArn;
    private final String deviceCapabilities;
    private final String deviceName;
    private final String deviceStatus;
    private final String deviceType;
    private final String providerName;

    private GetDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
        this.deviceCapabilities = builder.deviceCapabilities;
        this.deviceName = builder.deviceName;
        this.deviceStatus = builder.deviceStatus;
        this.deviceType = builder.deviceType;
        this.providerName = builder.providerName;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public String deviceCapabilities() {
        return this.deviceCapabilities;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public DeviceStatus deviceStatus() {
        return DeviceStatus.fromValue(this.deviceStatus);
    }

    public String deviceStatusAsString() {
        return this.deviceStatus;
    }

    public DeviceType deviceType() {
        return DeviceType.fromValue(this.deviceType);
    }

    public String deviceTypeAsString() {
        return this.deviceType;
    }

    public String providerName() {
        return this.providerName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceResponse)) {
            return false;
        }
        GetDeviceResponse other = (GetDeviceResponse)((Object)obj);
        return Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.deviceCapabilities(), other.deviceCapabilities()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.deviceStatusAsString(), other.deviceStatusAsString()) && Objects.equals(this.deviceTypeAsString(), other.deviceTypeAsString()) && Objects.equals(this.providerName(), other.providerName());
    }

    public String toString() {
        return ToString.builder((String)"GetDeviceResponse").add("DeviceArn", (Object)this.deviceArn()).add("DeviceCapabilities", (Object)this.deviceCapabilities()).add("DeviceName", (Object)this.deviceName()).add("DeviceStatus", (Object)this.deviceStatusAsString()).add("DeviceType", (Object)this.deviceTypeAsString()).add("ProviderName", (Object)this.providerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "deviceCapabilities": {
                return Optional.ofNullable(clazz.cast(this.deviceCapabilities()));
            }
            case "deviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "deviceStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceStatusAsString()));
            }
            case "deviceType": {
                return Optional.ofNullable(clazz.cast(this.deviceTypeAsString()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceResponse, T> g) {
        return obj -> g.apply((GetDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketResponse.BuilderImpl
    implements Builder {
        private String deviceArn;
        private String deviceCapabilities;
        private String deviceName;
        private String deviceStatus;
        private String deviceType;
        private String providerName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceResponse model) {
            super(model);
            this.deviceArn(model.deviceArn);
            this.deviceCapabilities(model.deviceCapabilities);
            this.deviceName(model.deviceName);
            this.deviceStatus(model.deviceStatus);
            this.deviceType(model.deviceType);
            this.providerName(model.providerName);
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDeviceCapabilities() {
            return this.deviceCapabilities;
        }

        @Override
        public final Builder deviceCapabilities(String deviceCapabilities) {
            this.deviceCapabilities = deviceCapabilities;
            return this;
        }

        public final void setDeviceCapabilities(String deviceCapabilities) {
            this.deviceCapabilities = deviceCapabilities;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getDeviceStatus() {
            return this.deviceStatus;
        }

        @Override
        public final Builder deviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
            return this;
        }

        @Override
        public final Builder deviceStatus(DeviceStatus deviceStatus) {
            this.deviceStatus(deviceStatus == null ? null : deviceStatus.toString());
            return this;
        }

        public final void setDeviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
        }

        public final String getDeviceType() {
            return this.deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Override
        public final Builder deviceType(DeviceType deviceType) {
            this.deviceType(deviceType == null ? null : deviceType.toString());
            return this;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public GetDeviceResponse build() {
            return new GetDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BraketResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeviceResponse> {
        public Builder deviceArn(String var1);

        public Builder deviceCapabilities(String var1);

        public Builder deviceName(String var1);

        public Builder deviceStatus(String var1);

        public Builder deviceStatus(DeviceStatus var1);

        public Builder deviceType(String var1);

        public Builder deviceType(DeviceType var1);

        public Builder providerName(String var1);
    }
}

