/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.QuantumTaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuantumTaskSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuantumTaskSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(QuantumTaskSummary.getter(QuantumTaskSummary::createdAt)).setter(QuantumTaskSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QuantumTaskSummary.getter(QuantumTaskSummary::deviceArn)).setter(QuantumTaskSummary.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(QuantumTaskSummary.getter(QuantumTaskSummary::endedAt)).setter(QuantumTaskSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> OUTPUT_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QuantumTaskSummary.getter(QuantumTaskSummary::outputS3Bucket)).setter(QuantumTaskSummary.setter(Builder::outputS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Bucket").build()}).build();
    private static final SdkField<String> OUTPUT_S3_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QuantumTaskSummary.getter(QuantumTaskSummary::outputS3Directory)).setter(QuantumTaskSummary.setter(Builder::outputS3Directory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Directory").build()}).build();
    private static final SdkField<String> QUANTUM_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QuantumTaskSummary.getter(QuantumTaskSummary::quantumTaskArn)).setter(QuantumTaskSummary.setter(Builder::quantumTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantumTaskArn").build()}).build();
    private static final SdkField<Long> SHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(QuantumTaskSummary.getter(QuantumTaskSummary::shots)).setter(QuantumTaskSummary.setter(Builder::shots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shots").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QuantumTaskSummary.getter(QuantumTaskSummary::statusAsString)).setter(QuantumTaskSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DEVICE_ARN_FIELD, ENDED_AT_FIELD, OUTPUT_S3_BUCKET_FIELD, OUTPUT_S3_DIRECTORY_FIELD, QUANTUM_TASK_ARN_FIELD, SHOTS_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String deviceArn;
    private final Instant endedAt;
    private final String outputS3Bucket;
    private final String outputS3Directory;
    private final String quantumTaskArn;
    private final Long shots;
    private final String status;

    private QuantumTaskSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.deviceArn = builder.deviceArn;
        this.endedAt = builder.endedAt;
        this.outputS3Bucket = builder.outputS3Bucket;
        this.outputS3Directory = builder.outputS3Directory;
        this.quantumTaskArn = builder.quantumTaskArn;
        this.shots = builder.shots;
        this.status = builder.status;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public Instant endedAt() {
        return this.endedAt;
    }

    public String outputS3Bucket() {
        return this.outputS3Bucket;
    }

    public String outputS3Directory() {
        return this.outputS3Directory;
    }

    public String quantumTaskArn() {
        return this.quantumTaskArn;
    }

    public Long shots() {
        return this.shots;
    }

    public QuantumTaskStatus status() {
        return QuantumTaskStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Directory());
        hashCode = 31 * hashCode + Objects.hashCode(this.quantumTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.shots());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuantumTaskSummary)) {
            return false;
        }
        QuantumTaskSummary other = (QuantumTaskSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.outputS3Bucket(), other.outputS3Bucket()) && Objects.equals(this.outputS3Directory(), other.outputS3Directory()) && Objects.equals(this.quantumTaskArn(), other.quantumTaskArn()) && Objects.equals(this.shots(), other.shots()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"QuantumTaskSummary").add("CreatedAt", (Object)this.createdAt()).add("DeviceArn", (Object)this.deviceArn()).add("EndedAt", (Object)this.endedAt()).add("OutputS3Bucket", (Object)this.outputS3Bucket()).add("OutputS3Directory", (Object)this.outputS3Directory()).add("QuantumTaskArn", (Object)this.quantumTaskArn()).add("Shots", (Object)this.shots()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "deviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "outputS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.outputS3Bucket()));
            }
            case "outputS3Directory": {
                return Optional.ofNullable(clazz.cast(this.outputS3Directory()));
            }
            case "quantumTaskArn": {
                return Optional.ofNullable(clazz.cast(this.quantumTaskArn()));
            }
            case "shots": {
                return Optional.ofNullable(clazz.cast(this.shots()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuantumTaskSummary, T> g) {
        return obj -> g.apply((QuantumTaskSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String deviceArn;
        private Instant endedAt;
        private String outputS3Bucket;
        private String outputS3Directory;
        private String quantumTaskArn;
        private Long shots;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(QuantumTaskSummary model) {
            this.createdAt(model.createdAt);
            this.deviceArn(model.deviceArn);
            this.endedAt(model.endedAt);
            this.outputS3Bucket(model.outputS3Bucket);
            this.outputS3Directory(model.outputS3Directory);
            this.quantumTaskArn(model.quantumTaskArn);
            this.shots(model.shots);
            this.status(model.status);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        public final String getOutputS3Bucket() {
            return this.outputS3Bucket;
        }

        @Override
        public final Builder outputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
            return this;
        }

        public final void setOutputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
        }

        public final String getOutputS3Directory() {
            return this.outputS3Directory;
        }

        @Override
        public final Builder outputS3Directory(String outputS3Directory) {
            this.outputS3Directory = outputS3Directory;
            return this;
        }

        public final void setOutputS3Directory(String outputS3Directory) {
            this.outputS3Directory = outputS3Directory;
        }

        public final String getQuantumTaskArn() {
            return this.quantumTaskArn;
        }

        @Override
        public final Builder quantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
            return this;
        }

        public final void setQuantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
        }

        public final Long getShots() {
            return this.shots;
        }

        @Override
        public final Builder shots(Long shots) {
            this.shots = shots;
            return this;
        }

        public final void setShots(Long shots) {
            this.shots = shots;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QuantumTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public QuantumTaskSummary build() {
            return new QuantumTaskSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuantumTaskSummary> {
        public Builder createdAt(Instant var1);

        public Builder deviceArn(String var1);

        public Builder endedAt(Instant var1);

        public Builder outputS3Bucket(String var1);

        public Builder outputS3Directory(String var1);

        public Builder quantumTaskArn(String var1);

        public Builder shots(Long var1);

        public Builder status(String var1);

        public Builder status(QuantumTaskStatus var1);
    }
}

