/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.BraketRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQuantumTaskRequest
extends BraketRequest
implements ToCopyableBuilder<Builder, CreateQuantumTaskRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::action)).setter(CreateQuantumTaskRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::clientToken)).setter(CreateQuantumTaskRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::deviceArn)).setter(CreateQuantumTaskRequest.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()}).build();
    private static final SdkField<String> DEVICE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::deviceParameters)).setter(CreateQuantumTaskRequest.setter(Builder::deviceParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceParameters").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> OUTPUT_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::outputS3Bucket)).setter(CreateQuantumTaskRequest.setter(Builder::outputS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Bucket").build()}).build();
    private static final SdkField<String> OUTPUT_S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::outputS3KeyPrefix)).setter(CreateQuantumTaskRequest.setter(Builder::outputS3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3KeyPrefix").build()}).build();
    private static final SdkField<Long> SHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::shots)).setter(CreateQuantumTaskRequest.setter(Builder::shots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shots").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, CLIENT_TOKEN_FIELD, DEVICE_ARN_FIELD, DEVICE_PARAMETERS_FIELD, OUTPUT_S3_BUCKET_FIELD, OUTPUT_S3_KEY_PREFIX_FIELD, SHOTS_FIELD));
    private final String action;
    private final String clientToken;
    private final String deviceArn;
    private final String deviceParameters;
    private final String outputS3Bucket;
    private final String outputS3KeyPrefix;
    private final Long shots;

    private CreateQuantumTaskRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.clientToken = builder.clientToken;
        this.deviceArn = builder.deviceArn;
        this.deviceParameters = builder.deviceParameters;
        this.outputS3Bucket = builder.outputS3Bucket;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.shots = builder.shots;
    }

    public String action() {
        return this.action;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public String deviceParameters() {
        return this.deviceParameters;
    }

    public String outputS3Bucket() {
        return this.outputS3Bucket;
    }

    public String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public Long shots() {
        return this.shots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.shots());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQuantumTaskRequest)) {
            return false;
        }
        CreateQuantumTaskRequest other = (CreateQuantumTaskRequest)((Object)obj);
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.deviceParameters(), other.deviceParameters()) && Objects.equals(this.outputS3Bucket(), other.outputS3Bucket()) && Objects.equals(this.outputS3KeyPrefix(), other.outputS3KeyPrefix()) && Objects.equals(this.shots(), other.shots());
    }

    public String toString() {
        return ToString.builder((String)"CreateQuantumTaskRequest").add("Action", (Object)this.action()).add("ClientToken", (Object)this.clientToken()).add("DeviceArn", (Object)this.deviceArn()).add("DeviceParameters", (Object)this.deviceParameters()).add("OutputS3Bucket", (Object)this.outputS3Bucket()).add("OutputS3KeyPrefix", (Object)this.outputS3KeyPrefix()).add("Shots", (Object)this.shots()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "deviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "deviceParameters": {
                return Optional.ofNullable(clazz.cast(this.deviceParameters()));
            }
            case "outputS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.outputS3Bucket()));
            }
            case "outputS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.outputS3KeyPrefix()));
            }
            case "shots": {
                return Optional.ofNullable(clazz.cast(this.shots()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQuantumTaskRequest, T> g) {
        return obj -> g.apply((CreateQuantumTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketRequest.BuilderImpl
    implements Builder {
        private String action;
        private String clientToken;
        private String deviceArn;
        private String deviceParameters;
        private String outputS3Bucket;
        private String outputS3KeyPrefix;
        private Long shots;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQuantumTaskRequest model) {
            super(model);
            this.action(model.action);
            this.clientToken(model.clientToken);
            this.deviceArn(model.deviceArn);
            this.deviceParameters(model.deviceParameters);
            this.outputS3Bucket(model.outputS3Bucket);
            this.outputS3KeyPrefix(model.outputS3KeyPrefix);
            this.shots(model.shots);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDeviceParameters() {
            return this.deviceParameters;
        }

        @Override
        public final Builder deviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
            return this;
        }

        public final void setDeviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
        }

        public final String getOutputS3Bucket() {
            return this.outputS3Bucket;
        }

        @Override
        public final Builder outputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
            return this;
        }

        public final void setOutputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final Long getShots() {
            return this.shots;
        }

        @Override
        public final Builder shots(Long shots) {
            this.shots = shots;
            return this;
        }

        public final void setShots(Long shots) {
            this.shots = shots;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQuantumTaskRequest build() {
            return new CreateQuantumTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BraketRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateQuantumTaskRequest> {
        public Builder action(String var1);

        public Builder clientToken(String var1);

        public Builder deviceArn(String var1);

        public Builder deviceParameters(String var1);

        public Builder outputS3Bucket(String var1);

        public Builder outputS3KeyPrefix(String var1);

        public Builder shots(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

