/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingPeriodRange;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.GroupByAttributeName;
import software.amazon.awssdk.services.billingconductor.model.GroupByAttributesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBillingGroupCostReportRequest
extends BillingconductorRequest
implements ToCopyableBuilder<Builder, GetBillingGroupCostReportRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetBillingGroupCostReportRequest.getter(GetBillingGroupCostReportRequest::arn)).setter(GetBillingGroupCostReportRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<BillingPeriodRange> BILLING_PERIOD_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingPeriodRange").getter(GetBillingGroupCostReportRequest.getter(GetBillingGroupCostReportRequest::billingPeriodRange)).setter(GetBillingGroupCostReportRequest.setter(Builder::billingPeriodRange)).constructor(BillingPeriodRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriodRange").build()}).build();
    private static final SdkField<List<String>> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupBy").getter(GetBillingGroupCostReportRequest.getter(GetBillingGroupCostReportRequest::groupByAsStrings)).setter(GetBillingGroupCostReportRequest.setter(Builder::groupByWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetBillingGroupCostReportRequest.getter(GetBillingGroupCostReportRequest::maxResults)).setter(GetBillingGroupCostReportRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetBillingGroupCostReportRequest.getter(GetBillingGroupCostReportRequest::nextToken)).setter(GetBillingGroupCostReportRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BILLING_PERIOD_RANGE_FIELD, GROUP_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBillingGroupCostReportRequest.memberNameToFieldInitializer();
    private final String arn;
    private final BillingPeriodRange billingPeriodRange;
    private final List<String> groupBy;
    private final Integer maxResults;
    private final String nextToken;

    private GetBillingGroupCostReportRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.billingPeriodRange = builder.billingPeriodRange;
        this.groupBy = builder.groupBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String arn() {
        return this.arn;
    }

    public final BillingPeriodRange billingPeriodRange() {
        return this.billingPeriodRange;
    }

    public final List<GroupByAttributeName> groupBy() {
        return GroupByAttributesListCopier.copyStringToEnum(this.groupBy);
    }

    public final boolean hasGroupBy() {
        return this.groupBy != null && !(this.groupBy instanceof SdkAutoConstructList);
    }

    public final List<String> groupByAsStrings() {
        return this.groupBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriodRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupBy() ? this.groupByAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBillingGroupCostReportRequest)) {
            return false;
        }
        GetBillingGroupCostReportRequest other = (GetBillingGroupCostReportRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.billingPeriodRange(), other.billingPeriodRange()) && this.hasGroupBy() == other.hasGroupBy() && Objects.equals(this.groupByAsStrings(), other.groupByAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetBillingGroupCostReportRequest").add("Arn", (Object)this.arn()).add("BillingPeriodRange", (Object)this.billingPeriodRange()).add("GroupBy", this.hasGroupBy() ? this.groupByAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "BillingPeriodRange": {
                return Optional.ofNullable(clazz.cast(this.billingPeriodRange()));
            }
            case "GroupBy": {
                return Optional.ofNullable(clazz.cast(this.groupByAsStrings()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("BillingPeriodRange", BILLING_PERIOD_RANGE_FIELD);
        map.put("GroupBy", GROUP_BY_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBillingGroupCostReportRequest, T> g) {
        return obj -> g.apply((GetBillingGroupCostReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorRequest.BuilderImpl
    implements Builder {
        private String arn;
        private BillingPeriodRange billingPeriodRange;
        private List<String> groupBy = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBillingGroupCostReportRequest model) {
            super(model);
            this.arn(model.arn);
            this.billingPeriodRange(model.billingPeriodRange);
            this.groupByWithStrings(model.groupBy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final BillingPeriodRange.Builder getBillingPeriodRange() {
            return this.billingPeriodRange != null ? this.billingPeriodRange.toBuilder() : null;
        }

        public final void setBillingPeriodRange(BillingPeriodRange.BuilderImpl billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange != null ? billingPeriodRange.build() : null;
        }

        @Override
        public final Builder billingPeriodRange(BillingPeriodRange billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        public final Collection<String> getGroupBy() {
            if (this.groupBy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupBy;
        }

        public final void setGroupBy(Collection<String> groupBy) {
            this.groupBy = GroupByAttributesListCopier.copy(groupBy);
        }

        @Override
        public final Builder groupByWithStrings(Collection<String> groupBy) {
            this.groupBy = GroupByAttributesListCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByWithStrings(String ... groupBy) {
            this.groupByWithStrings(Arrays.asList(groupBy));
            return this;
        }

        @Override
        public final Builder groupBy(Collection<GroupByAttributeName> groupBy) {
            this.groupBy = GroupByAttributesListCopier.copyEnumToString(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupByAttributeName ... groupBy) {
            this.groupBy(Arrays.asList(groupBy));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBillingGroupCostReportRequest build() {
            return new GetBillingGroupCostReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingconductorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBillingGroupCostReportRequest> {
        public Builder arn(String var1);

        public Builder billingPeriodRange(BillingPeriodRange var1);

        default public Builder billingPeriodRange(Consumer<BillingPeriodRange.Builder> billingPeriodRange) {
            return this.billingPeriodRange((BillingPeriodRange)((BillingPeriodRange.Builder)BillingPeriodRange.builder().applyMutation(billingPeriodRange)).build());
        }

        public Builder groupByWithStrings(Collection<String> var1);

        public Builder groupByWithStrings(String ... var1);

        public Builder groupBy(Collection<GroupByAttributeName> var1);

        public Builder groupBy(GroupByAttributeName ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

