/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.LineItemFilter;
import software.amazon.awssdk.services.billingconductor.model.LineItemFiltersListCopier;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemFlatChargeDetails;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemPercentageChargeDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCustomLineItemChargeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateCustomLineItemChargeDetails> {
    private static final SdkField<UpdateCustomLineItemFlatChargeDetails> FLAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Flat").getter(UpdateCustomLineItemChargeDetails.getter(UpdateCustomLineItemChargeDetails::flat)).setter(UpdateCustomLineItemChargeDetails.setter(Builder::flat)).constructor(UpdateCustomLineItemFlatChargeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flat").build()}).build();
    private static final SdkField<UpdateCustomLineItemPercentageChargeDetails> PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Percentage").getter(UpdateCustomLineItemChargeDetails.getter(UpdateCustomLineItemChargeDetails::percentage)).setter(UpdateCustomLineItemChargeDetails.setter(Builder::percentage)).constructor(UpdateCustomLineItemPercentageChargeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentage").build()}).build();
    private static final SdkField<List<LineItemFilter>> LINE_ITEM_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LineItemFilters").getter(UpdateCustomLineItemChargeDetails.getter(UpdateCustomLineItemChargeDetails::lineItemFilters)).setter(UpdateCustomLineItemChargeDetails.setter(Builder::lineItemFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineItemFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineItemFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLAT_FIELD, PERCENTAGE_FIELD, LINE_ITEM_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCustomLineItemChargeDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final UpdateCustomLineItemFlatChargeDetails flat;
    private final UpdateCustomLineItemPercentageChargeDetails percentage;
    private final List<LineItemFilter> lineItemFilters;

    private UpdateCustomLineItemChargeDetails(BuilderImpl builder) {
        this.flat = builder.flat;
        this.percentage = builder.percentage;
        this.lineItemFilters = builder.lineItemFilters;
    }

    public final UpdateCustomLineItemFlatChargeDetails flat() {
        return this.flat;
    }

    public final UpdateCustomLineItemPercentageChargeDetails percentage() {
        return this.percentage;
    }

    public final boolean hasLineItemFilters() {
        return this.lineItemFilters != null && !(this.lineItemFilters instanceof SdkAutoConstructList);
    }

    public final List<LineItemFilter> lineItemFilters() {
        return this.lineItemFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flat());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineItemFilters() ? this.lineItemFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomLineItemChargeDetails)) {
            return false;
        }
        UpdateCustomLineItemChargeDetails other = (UpdateCustomLineItemChargeDetails)obj;
        return Objects.equals(this.flat(), other.flat()) && Objects.equals(this.percentage(), other.percentage()) && this.hasLineItemFilters() == other.hasLineItemFilters() && Objects.equals(this.lineItemFilters(), other.lineItemFilters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCustomLineItemChargeDetails").add("Flat", (Object)this.flat()).add("Percentage", (Object)this.percentage()).add("LineItemFilters", this.hasLineItemFilters() ? this.lineItemFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Flat": {
                return Optional.ofNullable(clazz.cast(this.flat()));
            }
            case "Percentage": {
                return Optional.ofNullable(clazz.cast(this.percentage()));
            }
            case "LineItemFilters": {
                return Optional.ofNullable(clazz.cast(this.lineItemFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Flat", FLAT_FIELD);
        map.put("Percentage", PERCENTAGE_FIELD);
        map.put("LineItemFilters", LINE_ITEM_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomLineItemChargeDetails, T> g) {
        return obj -> g.apply((UpdateCustomLineItemChargeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UpdateCustomLineItemFlatChargeDetails flat;
        private UpdateCustomLineItemPercentageChargeDetails percentage;
        private List<LineItemFilter> lineItemFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomLineItemChargeDetails model) {
            this.flat(model.flat);
            this.percentage(model.percentage);
            this.lineItemFilters(model.lineItemFilters);
        }

        public final UpdateCustomLineItemFlatChargeDetails.Builder getFlat() {
            return this.flat != null ? this.flat.toBuilder() : null;
        }

        public final void setFlat(UpdateCustomLineItemFlatChargeDetails.BuilderImpl flat) {
            this.flat = flat != null ? flat.build() : null;
        }

        @Override
        public final Builder flat(UpdateCustomLineItemFlatChargeDetails flat) {
            this.flat = flat;
            return this;
        }

        public final UpdateCustomLineItemPercentageChargeDetails.Builder getPercentage() {
            return this.percentage != null ? this.percentage.toBuilder() : null;
        }

        public final void setPercentage(UpdateCustomLineItemPercentageChargeDetails.BuilderImpl percentage) {
            this.percentage = percentage != null ? percentage.build() : null;
        }

        @Override
        public final Builder percentage(UpdateCustomLineItemPercentageChargeDetails percentage) {
            this.percentage = percentage;
            return this;
        }

        public final List<LineItemFilter.Builder> getLineItemFilters() {
            List<LineItemFilter.Builder> result = LineItemFiltersListCopier.copyToBuilder(this.lineItemFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineItemFilters(Collection<LineItemFilter.BuilderImpl> lineItemFilters) {
            this.lineItemFilters = LineItemFiltersListCopier.copyFromBuilder(lineItemFilters);
        }

        @Override
        public final Builder lineItemFilters(Collection<LineItemFilter> lineItemFilters) {
            this.lineItemFilters = LineItemFiltersListCopier.copy(lineItemFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemFilters(LineItemFilter ... lineItemFilters) {
            this.lineItemFilters(Arrays.asList(lineItemFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineItemFilters(Consumer<LineItemFilter.Builder> ... lineItemFilters) {
            this.lineItemFilters(Stream.of(lineItemFilters).map(c -> (LineItemFilter)((LineItemFilter.Builder)LineItemFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UpdateCustomLineItemChargeDetails build() {
            return new UpdateCustomLineItemChargeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateCustomLineItemChargeDetails> {
        public Builder flat(UpdateCustomLineItemFlatChargeDetails var1);

        default public Builder flat(Consumer<UpdateCustomLineItemFlatChargeDetails.Builder> flat) {
            return this.flat((UpdateCustomLineItemFlatChargeDetails)((UpdateCustomLineItemFlatChargeDetails.Builder)UpdateCustomLineItemFlatChargeDetails.builder().applyMutation(flat)).build());
        }

        public Builder percentage(UpdateCustomLineItemPercentageChargeDetails var1);

        default public Builder percentage(Consumer<UpdateCustomLineItemPercentageChargeDetails.Builder> percentage) {
            return this.percentage((UpdateCustomLineItemPercentageChargeDetails)((UpdateCustomLineItemPercentageChargeDetails.Builder)UpdateCustomLineItemPercentageChargeDetails.builder().applyMutation(percentage)).build());
        }

        public Builder lineItemFilters(Collection<LineItemFilter> var1);

        public Builder lineItemFilters(LineItemFilter ... var1);

        public Builder lineItemFilters(Consumer<LineItemFilter.Builder> ... var1);
    }
}

