/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse;
import software.amazon.awssdk.services.billingconductor.model.PricingPlanListElement;

public class ListPricingPlansIterable
implements SdkIterable<ListPricingPlansResponse> {
    private final BillingconductorClient client;
    private final ListPricingPlansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPricingPlansIterable(BillingconductorClient client, ListPricingPlansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPricingPlansResponseFetcher();
    }

    public Iterator<ListPricingPlansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PricingPlanListElement> pricingPlans() {
        Function<ListPricingPlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.pricingPlans() != null) {
                return response.pricingPlans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPricingPlansResponseFetcher
    implements SyncPageFetcher<ListPricingPlansResponse> {
        private ListPricingPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListPricingPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPricingPlansResponse nextPage(ListPricingPlansResponse previousPage) {
            if (previousPage == null) {
                return ListPricingPlansIterable.this.client.listPricingPlans(ListPricingPlansIterable.this.firstRequest);
            }
            return ListPricingPlansIterable.this.client.listPricingPlans((ListPricingPlansRequest)((Object)ListPricingPlansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

