/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of the new charge details that are associated with a percentage custom line item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCustomLineItemPercentageChargeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateCustomLineItemPercentageChargeDetails.Builder, UpdateCustomLineItemPercentageChargeDetails> {
    private static final SdkField<Double> PERCENTAGE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("PercentageValue").getter(getter(UpdateCustomLineItemPercentageChargeDetails::percentageValue))
            .setter(setter(Builder::percentageValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENTAGE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double percentageValue;

    private UpdateCustomLineItemPercentageChargeDetails(BuilderImpl builder) {
        this.percentageValue = builder.percentageValue;
    }

    /**
     * <p>
     * The custom line item's new percentage value. This will be multiplied against the combined value of its associated
     * resources to determine its charge value.
     * </p>
     * 
     * @return The custom line item's new percentage value. This will be multiplied against the combined value of its
     *         associated resources to determine its charge value.
     */
    public final Double percentageValue() {
        return percentageValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(percentageValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomLineItemPercentageChargeDetails)) {
            return false;
        }
        UpdateCustomLineItemPercentageChargeDetails other = (UpdateCustomLineItemPercentageChargeDetails) obj;
        return Objects.equals(percentageValue(), other.percentageValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCustomLineItemPercentageChargeDetails").add("PercentageValue", percentageValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PercentageValue":
            return Optional.ofNullable(clazz.cast(percentageValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomLineItemPercentageChargeDetails, T> g) {
        return obj -> g.apply((UpdateCustomLineItemPercentageChargeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateCustomLineItemPercentageChargeDetails> {
        /**
         * <p>
         * The custom line item's new percentage value. This will be multiplied against the combined value of its
         * associated resources to determine its charge value.
         * </p>
         * 
         * @param percentageValue
         *        The custom line item's new percentage value. This will be multiplied against the combined value of its
         *        associated resources to determine its charge value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentageValue(Double percentageValue);
    }

    static final class BuilderImpl implements Builder {
        private Double percentageValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomLineItemPercentageChargeDetails model) {
            percentageValue(model.percentageValue);
        }

        public final Double getPercentageValue() {
            return percentageValue;
        }

        public final void setPercentageValue(Double percentageValue) {
            this.percentageValue = percentageValue;
        }

        @Override
        public final Builder percentageValue(Double percentageValue) {
            this.percentageValue = percentageValue;
            return this;
        }

        @Override
        public UpdateCustomLineItemPercentageChargeDetails build() {
            return new UpdateCustomLineItemPercentageChargeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
