/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBillingGroupRequest extends BillingconductorRequest implements
        ToCopyableBuilder<CreateBillingGroupRequest.Builder, CreateBillingGroupRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateBillingGroupRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateBillingGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AccountGrouping> ACCOUNT_GROUPING_FIELD = SdkField
            .<AccountGrouping> builder(MarshallingType.SDK_POJO).memberName("AccountGrouping")
            .getter(getter(CreateBillingGroupRequest::accountGrouping)).setter(setter(Builder::accountGrouping))
            .constructor(AccountGrouping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountGrouping").build()).build();

    private static final SdkField<ComputationPreference> COMPUTATION_PREFERENCE_FIELD = SdkField
            .<ComputationPreference> builder(MarshallingType.SDK_POJO).memberName("ComputationPreference")
            .getter(getter(CreateBillingGroupRequest::computationPreference)).setter(setter(Builder::computationPreference))
            .constructor(ComputationPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationPreference").build())
            .build();

    private static final SdkField<String> PRIMARY_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountId").getter(getter(CreateBillingGroupRequest::primaryAccountId))
            .setter(setter(Builder::primaryAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateBillingGroupRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateBillingGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            NAME_FIELD, ACCOUNT_GROUPING_FIELD, COMPUTATION_PREFERENCE_FIELD, PRIMARY_ACCOUNT_ID_FIELD, DESCRIPTION_FIELD,
            TAGS_FIELD));

    private final String clientToken;

    private final String name;

    private final AccountGrouping accountGrouping;

    private final ComputationPreference computationPreference;

    private final String primaryAccountId;

    private final String description;

    private final Map<String, String> tags;

    private CreateBillingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.accountGrouping = builder.accountGrouping;
        this.computationPreference = builder.computationPreference;
        this.primaryAccountId = builder.primaryAccountId;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The token that is needed to support idempotency. Idempotency isn't currently supported, but will be implemented
     * in a future update.
     * </p>
     * 
     * @return The token that is needed to support idempotency. Idempotency isn't currently supported, but will be
     *         implemented in a future update.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The billing group name. The names must be unique.
     * </p>
     * 
     * @return The billing group name. The names must be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a
     * consolidated family.
     * </p>
     * 
     * @return The set of accounts that will be under the billing group. The set of accounts resemble the linked
     *         accounts in a consolidated family.
     */
    public final AccountGrouping accountGrouping() {
        return accountGrouping;
    }

    /**
     * <p>
     * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing group.
     * </p>
     * 
     * @return The preferences and settings that will be used to compute the Amazon Web Services charges for a billing
     *         group.
     */
    public final ComputationPreference computationPreference() {
        return computationPreference;
    }

    /**
     * <p>
     * The account ID that serves as the main account in a billing group.
     * </p>
     * 
     * @return The account ID that serves as the main account in a billing group.
     */
    public final String primaryAccountId() {
        return primaryAccountId;
    }

    /**
     * <p>
     * The description of the billing group.
     * </p>
     * 
     * @return The description of the billing group.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to a billing group. This feature isn't available
     * during the beta.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to a billing group. This feature isn't
     *         available during the beta.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(accountGrouping());
        hashCode = 31 * hashCode + Objects.hashCode(computationPreference());
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBillingGroupRequest)) {
            return false;
        }
        CreateBillingGroupRequest other = (CreateBillingGroupRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(name(), other.name())
                && Objects.equals(accountGrouping(), other.accountGrouping())
                && Objects.equals(computationPreference(), other.computationPreference())
                && Objects.equals(primaryAccountId(), other.primaryAccountId())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBillingGroupRequest").add("ClientToken", clientToken())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("AccountGrouping", accountGrouping())
                .add("ComputationPreference", computationPreference()).add("PrimaryAccountId", primaryAccountId())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AccountGrouping":
            return Optional.ofNullable(clazz.cast(accountGrouping()));
        case "ComputationPreference":
            return Optional.ofNullable(clazz.cast(computationPreference()));
        case "PrimaryAccountId":
            return Optional.ofNullable(clazz.cast(primaryAccountId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBillingGroupRequest, T> g) {
        return obj -> g.apply((CreateBillingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBillingGroupRequest> {
        /**
         * <p>
         * The token that is needed to support idempotency. Idempotency isn't currently supported, but will be
         * implemented in a future update.
         * </p>
         * 
         * @param clientToken
         *        The token that is needed to support idempotency. Idempotency isn't currently supported, but will be
         *        implemented in a future update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The billing group name. The names must be unique.
         * </p>
         * 
         * @param name
         *        The billing group name. The names must be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in
         * a consolidated family.
         * </p>
         * 
         * @param accountGrouping
         *        The set of accounts that will be under the billing group. The set of accounts resemble the linked
         *        accounts in a consolidated family.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountGrouping(AccountGrouping accountGrouping);

        /**
         * <p>
         * The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in
         * a consolidated family.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountGrouping.Builder} avoiding the
         * need to create one manually via {@link AccountGrouping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountGrouping.Builder#build()} is called immediately and its
         * result is passed to {@link #accountGrouping(AccountGrouping)}.
         * 
         * @param accountGrouping
         *        a consumer that will call methods on {@link AccountGrouping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountGrouping(AccountGrouping)
         */
        default Builder accountGrouping(Consumer<AccountGrouping.Builder> accountGrouping) {
            return accountGrouping(AccountGrouping.builder().applyMutation(accountGrouping).build());
        }

        /**
         * <p>
         * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing
         * group.
         * </p>
         * 
         * @param computationPreference
         *        The preferences and settings that will be used to compute the Amazon Web Services charges for a
         *        billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationPreference(ComputationPreference computationPreference);

        /**
         * <p>
         * The preferences and settings that will be used to compute the Amazon Web Services charges for a billing
         * group.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputationPreference.Builder} avoiding
         * the need to create one manually via {@link ComputationPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputationPreference.Builder#build()} is called immediately and
         * its result is passed to {@link #computationPreference(ComputationPreference)}.
         * 
         * @param computationPreference
         *        a consumer that will call methods on {@link ComputationPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computationPreference(ComputationPreference)
         */
        default Builder computationPreference(Consumer<ComputationPreference.Builder> computationPreference) {
            return computationPreference(ComputationPreference.builder().applyMutation(computationPreference).build());
        }

        /**
         * <p>
         * The account ID that serves as the main account in a billing group.
         * </p>
         * 
         * @param primaryAccountId
         *        The account ID that serves as the main account in a billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountId(String primaryAccountId);

        /**
         * <p>
         * The description of the billing group.
         * </p>
         * 
         * @param description
         *        The description of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to a billing group. This feature isn't
         * available during the beta.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to a billing group. This feature isn't
         *        available during the beta.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String name;

        private AccountGrouping accountGrouping;

        private ComputationPreference computationPreference;

        private String primaryAccountId;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBillingGroupRequest model) {
            super(model);
            clientToken(model.clientToken);
            name(model.name);
            accountGrouping(model.accountGrouping);
            computationPreference(model.computationPreference);
            primaryAccountId(model.primaryAccountId);
            description(model.description);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AccountGrouping.Builder getAccountGrouping() {
            return accountGrouping != null ? accountGrouping.toBuilder() : null;
        }

        public final void setAccountGrouping(AccountGrouping.BuilderImpl accountGrouping) {
            this.accountGrouping = accountGrouping != null ? accountGrouping.build() : null;
        }

        @Override
        public final Builder accountGrouping(AccountGrouping accountGrouping) {
            this.accountGrouping = accountGrouping;
            return this;
        }

        public final ComputationPreference.Builder getComputationPreference() {
            return computationPreference != null ? computationPreference.toBuilder() : null;
        }

        public final void setComputationPreference(ComputationPreference.BuilderImpl computationPreference) {
            this.computationPreference = computationPreference != null ? computationPreference.build() : null;
        }

        @Override
        public final Builder computationPreference(ComputationPreference computationPreference) {
            this.computationPreference = computationPreference;
            return this;
        }

        public final String getPrimaryAccountId() {
            return primaryAccountId;
        }

        public final void setPrimaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
        }

        @Override
        public final Builder primaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBillingGroupRequest build() {
            return new CreateBillingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
