/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of the new charge details of a custom line item. This should contain only one of <code>Flat</code>
 * or <code>Percentage</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCustomLineItemChargeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateCustomLineItemChargeDetails.Builder, UpdateCustomLineItemChargeDetails> {
    private static final SdkField<UpdateCustomLineItemFlatChargeDetails> FLAT_FIELD = SdkField
            .<UpdateCustomLineItemFlatChargeDetails> builder(MarshallingType.SDK_POJO).memberName("Flat")
            .getter(getter(UpdateCustomLineItemChargeDetails::flat)).setter(setter(Builder::flat))
            .constructor(UpdateCustomLineItemFlatChargeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flat").build()).build();

    private static final SdkField<UpdateCustomLineItemPercentageChargeDetails> PERCENTAGE_FIELD = SdkField
            .<UpdateCustomLineItemPercentageChargeDetails> builder(MarshallingType.SDK_POJO).memberName("Percentage")
            .getter(getter(UpdateCustomLineItemChargeDetails::percentage)).setter(setter(Builder::percentage))
            .constructor(UpdateCustomLineItemPercentageChargeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLAT_FIELD, PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final UpdateCustomLineItemFlatChargeDetails flat;

    private final UpdateCustomLineItemPercentageChargeDetails percentage;

    private UpdateCustomLineItemChargeDetails(BuilderImpl builder) {
        this.flat = builder.flat;
        this.percentage = builder.percentage;
    }

    /**
     * <p>
     * An <code>UpdateCustomLineItemFlatChargeDetails</code> that describes the new charge details of a flat custom line
     * item.
     * </p>
     * 
     * @return An <code>UpdateCustomLineItemFlatChargeDetails</code> that describes the new charge details of a flat
     *         custom line item.
     */
    public final UpdateCustomLineItemFlatChargeDetails flat() {
        return flat;
    }

    /**
     * <p>
     * An <code>UpdateCustomLineItemPercentageChargeDetails</code> that describes the new charge details of a percentage
     * custom line item.
     * </p>
     * 
     * @return An <code>UpdateCustomLineItemPercentageChargeDetails</code> that describes the new charge details of a
     *         percentage custom line item.
     */
    public final UpdateCustomLineItemPercentageChargeDetails percentage() {
        return percentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flat());
        hashCode = 31 * hashCode + Objects.hashCode(percentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomLineItemChargeDetails)) {
            return false;
        }
        UpdateCustomLineItemChargeDetails other = (UpdateCustomLineItemChargeDetails) obj;
        return Objects.equals(flat(), other.flat()) && Objects.equals(percentage(), other.percentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCustomLineItemChargeDetails").add("Flat", flat()).add("Percentage", percentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Flat":
            return Optional.ofNullable(clazz.cast(flat()));
        case "Percentage":
            return Optional.ofNullable(clazz.cast(percentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomLineItemChargeDetails, T> g) {
        return obj -> g.apply((UpdateCustomLineItemChargeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateCustomLineItemChargeDetails> {
        /**
         * <p>
         * An <code>UpdateCustomLineItemFlatChargeDetails</code> that describes the new charge details of a flat custom
         * line item.
         * </p>
         * 
         * @param flat
         *        An <code>UpdateCustomLineItemFlatChargeDetails</code> that describes the new charge details of a flat
         *        custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flat(UpdateCustomLineItemFlatChargeDetails flat);

        /**
         * <p>
         * An <code>UpdateCustomLineItemFlatChargeDetails</code> that describes the new charge details of a flat custom
         * line item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateCustomLineItemFlatChargeDetails.Builder} avoiding the need to create one manually via
         * {@link UpdateCustomLineItemFlatChargeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateCustomLineItemFlatChargeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #flat(UpdateCustomLineItemFlatChargeDetails)}.
         * 
         * @param flat
         *        a consumer that will call methods on {@link UpdateCustomLineItemFlatChargeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flat(UpdateCustomLineItemFlatChargeDetails)
         */
        default Builder flat(Consumer<UpdateCustomLineItemFlatChargeDetails.Builder> flat) {
            return flat(UpdateCustomLineItemFlatChargeDetails.builder().applyMutation(flat).build());
        }

        /**
         * <p>
         * An <code>UpdateCustomLineItemPercentageChargeDetails</code> that describes the new charge details of a
         * percentage custom line item.
         * </p>
         * 
         * @param percentage
         *        An <code>UpdateCustomLineItemPercentageChargeDetails</code> that describes the new charge details of a
         *        percentage custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentage(UpdateCustomLineItemPercentageChargeDetails percentage);

        /**
         * <p>
         * An <code>UpdateCustomLineItemPercentageChargeDetails</code> that describes the new charge details of a
         * percentage custom line item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateCustomLineItemPercentageChargeDetails.Builder} avoiding the need to create one manually via
         * {@link UpdateCustomLineItemPercentageChargeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateCustomLineItemPercentageChargeDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #percentage(UpdateCustomLineItemPercentageChargeDetails)}.
         * 
         * @param percentage
         *        a consumer that will call methods on {@link UpdateCustomLineItemPercentageChargeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #percentage(UpdateCustomLineItemPercentageChargeDetails)
         */
        default Builder percentage(Consumer<UpdateCustomLineItemPercentageChargeDetails.Builder> percentage) {
            return percentage(UpdateCustomLineItemPercentageChargeDetails.builder().applyMutation(percentage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateCustomLineItemFlatChargeDetails flat;

        private UpdateCustomLineItemPercentageChargeDetails percentage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomLineItemChargeDetails model) {
            flat(model.flat);
            percentage(model.percentage);
        }

        public final UpdateCustomLineItemFlatChargeDetails.Builder getFlat() {
            return flat != null ? flat.toBuilder() : null;
        }

        public final void setFlat(UpdateCustomLineItemFlatChargeDetails.BuilderImpl flat) {
            this.flat = flat != null ? flat.build() : null;
        }

        @Override
        public final Builder flat(UpdateCustomLineItemFlatChargeDetails flat) {
            this.flat = flat;
            return this;
        }

        public final UpdateCustomLineItemPercentageChargeDetails.Builder getPercentage() {
            return percentage != null ? percentage.toBuilder() : null;
        }

        public final void setPercentage(UpdateCustomLineItemPercentageChargeDetails.BuilderImpl percentage) {
            this.percentage = percentage != null ? percentage.build() : null;
        }

        @Override
        public final Builder percentage(UpdateCustomLineItemPercentageChargeDetails percentage) {
            this.percentage = percentage;
            return this;
        }

        @Override
        public UpdateCustomLineItemChargeDetails build() {
            return new UpdateCustomLineItemChargeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
