/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The set of accounts that will be under the billing group. The set of accounts resemble the linked accounts in a
 * consolidated family.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountGrouping implements SdkPojo, Serializable, ToCopyableBuilder<AccountGrouping.Builder, AccountGrouping> {
    private static final SdkField<List<String>> LINKED_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LinkedAccountIds")
            .getter(getter(AccountGrouping::linkedAccountIds))
            .setter(setter(Builder::linkedAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINKED_ACCOUNT_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> linkedAccountIds;

    private AccountGrouping(BuilderImpl builder) {
        this.linkedAccountIds = builder.linkedAccountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkedAccountIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLinkedAccountIds() {
        return linkedAccountIds != null && !(linkedAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing family,
     * and not associated with another billing group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkedAccountIds} method.
     * </p>
     * 
     * @return The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing
     *         family, and not associated with another billing group.
     */
    public final List<String> linkedAccountIds() {
        return linkedAccountIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkedAccountIds() ? linkedAccountIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountGrouping)) {
            return false;
        }
        AccountGrouping other = (AccountGrouping) obj;
        return hasLinkedAccountIds() == other.hasLinkedAccountIds()
                && Objects.equals(linkedAccountIds(), other.linkedAccountIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountGrouping").add("LinkedAccountIds", hasLinkedAccountIds() ? linkedAccountIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LinkedAccountIds":
            return Optional.ofNullable(clazz.cast(linkedAccountIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountGrouping, T> g) {
        return obj -> g.apply((AccountGrouping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountGrouping> {
        /**
         * <p>
         * The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing
         * family, and not associated with another billing group.
         * </p>
         * 
         * @param linkedAccountIds
         *        The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing
         *        family, and not associated with another billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedAccountIds(Collection<String> linkedAccountIds);

        /**
         * <p>
         * The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing
         * family, and not associated with another billing group.
         * </p>
         * 
         * @param linkedAccountIds
         *        The account IDs that make up the billing group. Account IDs must be a part of the consolidated billing
         *        family, and not associated with another billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedAccountIds(String... linkedAccountIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> linkedAccountIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountGrouping model) {
            linkedAccountIds(model.linkedAccountIds);
        }

        public final Collection<String> getLinkedAccountIds() {
            if (linkedAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return linkedAccountIds;
        }

        public final void setLinkedAccountIds(Collection<String> linkedAccountIds) {
            this.linkedAccountIds = AccountIdListCopier.copy(linkedAccountIds);
        }

        @Override
        public final Builder linkedAccountIds(Collection<String> linkedAccountIds) {
            this.linkedAccountIds = AccountIdListCopier.copy(linkedAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedAccountIds(String... linkedAccountIds) {
            linkedAccountIds(Arrays.asList(linkedAccountIds));
            return this;
        }

        @Override
        public AccountGrouping build() {
            return new AccountGrouping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
