/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of a linked account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountAssociationsListElement implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountAssociationsListElement.Builder, AccountAssociationsListElement> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AccountAssociationsListElement::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingGroupArn").getter(getter(AccountAssociationsListElement::billingGroupArn))
            .setter(setter(Builder::billingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArn").build()).build();

    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountName").getter(getter(AccountAssociationsListElement::accountName))
            .setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()).build();

    private static final SdkField<String> ACCOUNT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountEmail").getter(getter(AccountAssociationsListElement::accountEmail))
            .setter(setter(Builder::accountEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountEmail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            BILLING_GROUP_ARN_FIELD, ACCOUNT_NAME_FIELD, ACCOUNT_EMAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String billingGroupArn;

    private final String accountName;

    private final String accountEmail;

    private AccountAssociationsListElement(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.billingGroupArn = builder.billingGroupArn;
        this.accountName = builder.accountName;
        this.accountEmail = builder.accountEmail;
    }

    /**
     * <p>
     * The associating array of account IDs.
     * </p>
     * 
     * @return The associating array of account IDs.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Billing Group Arn that the linked account is associated to.
     * </p>
     * 
     * @return The Billing Group Arn that the linked account is associated to.
     */
    public final String billingGroupArn() {
        return billingGroupArn;
    }

    /**
     * <p>
     * The Amazon Web Services account name.
     * </p>
     * 
     * @return The Amazon Web Services account name.
     */
    public final String accountName() {
        return accountName;
    }

    /**
     * <p>
     * The Amazon Web Services account email.
     * </p>
     * 
     * @return The Amazon Web Services account email.
     */
    public final String accountEmail() {
        return accountEmail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(accountEmail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAssociationsListElement)) {
            return false;
        }
        AccountAssociationsListElement other = (AccountAssociationsListElement) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(billingGroupArn(), other.billingGroupArn())
                && Objects.equals(accountName(), other.accountName()) && Objects.equals(accountEmail(), other.accountEmail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountAssociationsListElement").add("AccountId", accountId())
                .add("BillingGroupArn", billingGroupArn())
                .add("AccountName", accountName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccountEmail", accountEmail() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "BillingGroupArn":
            return Optional.ofNullable(clazz.cast(billingGroupArn()));
        case "AccountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        case "AccountEmail":
            return Optional.ofNullable(clazz.cast(accountEmail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountAssociationsListElement, T> g) {
        return obj -> g.apply((AccountAssociationsListElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountAssociationsListElement> {
        /**
         * <p>
         * The associating array of account IDs.
         * </p>
         * 
         * @param accountId
         *        The associating array of account IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Billing Group Arn that the linked account is associated to.
         * </p>
         * 
         * @param billingGroupArn
         *        The Billing Group Arn that the linked account is associated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupArn(String billingGroupArn);

        /**
         * <p>
         * The Amazon Web Services account name.
         * </p>
         * 
         * @param accountName
         *        The Amazon Web Services account name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * <p>
         * The Amazon Web Services account email.
         * </p>
         * 
         * @param accountEmail
         *        The Amazon Web Services account email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountEmail(String accountEmail);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String billingGroupArn;

        private String accountName;

        private String accountEmail;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAssociationsListElement model) {
            accountId(model.accountId);
            billingGroupArn(model.billingGroupArn);
            accountName(model.accountName);
            accountEmail(model.accountEmail);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBillingGroupArn() {
            return billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final String getAccountName() {
            return accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getAccountEmail() {
            return accountEmail;
        }

        public final void setAccountEmail(String accountEmail) {
            this.accountEmail = accountEmail;
        }

        @Override
        public final Builder accountEmail(String accountEmail) {
            this.accountEmail = accountEmail;
            return this;
        }

        @Override
        public AccountAssociationsListElement build() {
            return new AccountAssociationsListElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
