/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.billingconductor.BillingconductorClient;
import software.amazon.awssdk.services.billingconductor.model.AccessDeniedException;
import software.amazon.awssdk.services.billingconductor.model.AssociateAccountsRequest;
import software.amazon.awssdk.services.billingconductor.model.AssociateAccountsResponse;
import software.amazon.awssdk.services.billingconductor.model.AssociatePricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.AssociatePricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorException;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.ConflictException;
import software.amazon.awssdk.services.billingconductor.model.CreateBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.CreateBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.CreateCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.CreateCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.DeleteBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.DeleteBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.DeleteCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.DeleteCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.DisassociateAccountsRequest;
import software.amazon.awssdk.services.billingconductor.model.DisassociateAccountsResponse;
import software.amazon.awssdk.services.billingconductor.model.DisassociatePricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.DisassociatePricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.InternalServerException;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.ResourceNotFoundException;
import software.amazon.awssdk.services.billingconductor.model.ServiceLimitExceededException;
import software.amazon.awssdk.services.billingconductor.model.TagResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.TagResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.ThrottlingException;
import software.amazon.awssdk.services.billingconductor.model.UntagResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.UntagResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.ValidationException;
import software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable;
import software.amazon.awssdk.services.billingconductor.transform.AssociateAccountsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.AssociatePricingRulesRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.BatchAssociateResourcesToCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.BatchDisassociateResourcesFromCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreateCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreatePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreatePricingRuleRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeleteBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeleteCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeletePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeletePricingRuleRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DisassociateAccountsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DisassociatePricingRulesRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListAccountAssociationsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListBillingGroupCostReportsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListBillingGroupsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListCustomLineItemVersionsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListCustomLineItemsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingPlansAssociatedWithPricingRuleRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingPlansRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingRulesAssociatedToPricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingRulesRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListResourcesAssociatedToCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdateCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdatePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdatePricingRuleRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultBillingconductorClient
implements BillingconductorClient {
    private static final Logger log = Logger.loggerFor(DefaultBillingconductorClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBillingconductorClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "billingconductor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateAccountsResponse associateAccounts(AssociateAccountsRequest associateAccountsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateAccountsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, associateAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateAccounts");
            AssociateAccountsResponse associateAccountsResponse = (AssociateAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateAccounts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateAccountsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateAccountsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$associateAccounts$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociatePricingRulesResponse associatePricingRules(AssociatePricingRulesRequest associatePricingRulesRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociatePricingRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, associatePricingRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociatePricingRules");
            AssociatePricingRulesResponse associatePricingRulesResponse = (AssociatePricingRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociatePricingRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associatePricingRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociatePricingRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associatePricingRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$associatePricingRules$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchAssociateResourcesToCustomLineItemResponse batchAssociateResourcesToCustomLineItem(BatchAssociateResourcesToCustomLineItemRequest batchAssociateResourcesToCustomLineItemRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchAssociateResourcesToCustomLineItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, batchAssociateResourcesToCustomLineItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchAssociateResourcesToCustomLineItem");
            BatchAssociateResourcesToCustomLineItemResponse batchAssociateResourcesToCustomLineItemResponse = (BatchAssociateResourcesToCustomLineItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchAssociateResourcesToCustomLineItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchAssociateResourcesToCustomLineItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchAssociateResourcesToCustomLineItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchAssociateResourcesToCustomLineItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$batchAssociateResourcesToCustomLineItem$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDisassociateResourcesFromCustomLineItemResponse batchDisassociateResourcesFromCustomLineItem(BatchDisassociateResourcesFromCustomLineItemRequest batchDisassociateResourcesFromCustomLineItemRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDisassociateResourcesFromCustomLineItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, batchDisassociateResourcesFromCustomLineItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDisassociateResourcesFromCustomLineItem");
            BatchDisassociateResourcesFromCustomLineItemResponse batchDisassociateResourcesFromCustomLineItemResponse = (BatchDisassociateResourcesFromCustomLineItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDisassociateResourcesFromCustomLineItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDisassociateResourcesFromCustomLineItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDisassociateResourcesFromCustomLineItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDisassociateResourcesFromCustomLineItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$batchDisassociateResourcesFromCustomLineItem$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBillingGroupResponse createBillingGroup(CreateBillingGroupRequest createBillingGroupRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, ServiceLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBillingGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, createBillingGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBillingGroup");
            CreateBillingGroupResponse createBillingGroupResponse = (CreateBillingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBillingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createBillingGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateBillingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createBillingGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$createBillingGroup$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCustomLineItemResponse createCustomLineItem(CreateCustomLineItemRequest createCustomLineItemRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, ServiceLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomLineItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, createCustomLineItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomLineItem");
            CreateCustomLineItemResponse createCustomLineItemResponse = (CreateCustomLineItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomLineItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCustomLineItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCustomLineItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCustomLineItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$createCustomLineItem$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePricingPlanResponse createPricingPlan(CreatePricingPlanRequest createPricingPlanRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePricingPlanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, createPricingPlanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePricingPlan");
            CreatePricingPlanResponse createPricingPlanResponse = (CreatePricingPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePricingPlan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPricingPlanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePricingPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPricingPlanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$createPricingPlan$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePricingRuleResponse createPricingRule(CreatePricingRuleRequest createPricingRuleRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, ServiceLimitExceededException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePricingRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, createPricingRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePricingRule");
            CreatePricingRuleResponse createPricingRuleResponse = (CreatePricingRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePricingRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPricingRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePricingRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPricingRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$createPricingRule$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBillingGroupResponse deleteBillingGroup(DeleteBillingGroupRequest deleteBillingGroupRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBillingGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, deleteBillingGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBillingGroup");
            DeleteBillingGroupResponse deleteBillingGroupResponse = (DeleteBillingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBillingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteBillingGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteBillingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteBillingGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$deleteBillingGroup$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCustomLineItemResponse deleteCustomLineItem(DeleteCustomLineItemRequest deleteCustomLineItemRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomLineItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, deleteCustomLineItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomLineItem");
            DeleteCustomLineItemResponse deleteCustomLineItemResponse = (DeleteCustomLineItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomLineItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCustomLineItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCustomLineItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCustomLineItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$deleteCustomLineItem$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePricingPlanResponse deletePricingPlan(DeletePricingPlanRequest deletePricingPlanRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePricingPlanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, deletePricingPlanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePricingPlan");
            DeletePricingPlanResponse deletePricingPlanResponse = (DeletePricingPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePricingPlan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePricingPlanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePricingPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePricingPlanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$deletePricingPlan$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePricingRuleResponse deletePricingRule(DeletePricingRuleRequest deletePricingRuleRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePricingRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, deletePricingRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePricingRule");
            DeletePricingRuleResponse deletePricingRuleResponse = (DeletePricingRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePricingRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePricingRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePricingRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePricingRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$deletePricingRule$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateAccountsResponse disassociateAccounts(DisassociateAccountsRequest disassociateAccountsRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateAccountsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, disassociateAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateAccounts");
            DisassociateAccountsResponse disassociateAccountsResponse = (DisassociateAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateAccounts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateAccountsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateAccountsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$disassociateAccounts$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociatePricingRulesResponse disassociatePricingRules(DisassociatePricingRulesRequest disassociatePricingRulesRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociatePricingRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, disassociatePricingRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociatePricingRules");
            DisassociatePricingRulesResponse disassociatePricingRulesResponse = (DisassociatePricingRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociatePricingRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociatePricingRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociatePricingRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociatePricingRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$disassociatePricingRules$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccountAssociationsResponse listAccountAssociations(ListAccountAssociationsRequest listAccountAssociationsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, listAccountAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccountAssociations");
            ListAccountAssociationsResponse listAccountAssociationsResponse = (ListAccountAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAccountAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAccountAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAccountAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$listAccountAssociations$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAccountAssociationsIterable listAccountAssociationsPaginator(ListAccountAssociationsRequest listAccountAssociationsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListAccountAssociationsIterable(this, this.applyPaginatorUserAgent(listAccountAssociationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBillingGroupCostReportsResponse listBillingGroupCostReports(ListBillingGroupCostReportsRequest listBillingGroupCostReportsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBillingGroupCostReportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, listBillingGroupCostReportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBillingGroupCostReports");
            ListBillingGroupCostReportsResponse listBillingGroupCostReportsResponse = (ListBillingGroupCostReportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBillingGroupCostReports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBillingGroupCostReportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBillingGroupCostReportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBillingGroupCostReportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$listBillingGroupCostReports$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListBillingGroupCostReportsIterable listBillingGroupCostReportsPaginator(ListBillingGroupCostReportsRequest listBillingGroupCostReportsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListBillingGroupCostReportsIterable(this, this.applyPaginatorUserAgent(listBillingGroupCostReportsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBillingGroupsResponse listBillingGroups(ListBillingGroupsRequest listBillingGroupsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBillingGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, listBillingGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBillingGroups");
            ListBillingGroupsResponse listBillingGroupsResponse = (ListBillingGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBillingGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBillingGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListBillingGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBillingGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$listBillingGroups$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListBillingGroupsIterable listBillingGroupsPaginator(ListBillingGroupsRequest listBillingGroupsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListBillingGroupsIterable(this, this.applyPaginatorUserAgent(listBillingGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCustomLineItemVersionsResponse listCustomLineItemVersions(ListCustomLineItemVersionsRequest listCustomLineItemVersionsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomLineItemVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, listCustomLineItemVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomLineItemVersions");
            ListCustomLineItemVersionsResponse listCustomLineItemVersionsResponse = (ListCustomLineItemVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomLineItemVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCustomLineItemVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCustomLineItemVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCustomLineItemVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$listCustomLineItemVersions$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCustomLineItemVersionsIterable listCustomLineItemVersionsPaginator(ListCustomLineItemVersionsRequest listCustomLineItemVersionsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListCustomLineItemVersionsIterable(this, this.applyPaginatorUserAgent(listCustomLineItemVersionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCustomLineItemsResponse listCustomLineItems(ListCustomLineItemsRequest listCustomLineItemsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomLineItemsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, listCustomLineItemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCustomLineItems");
            ListCustomLineItemsResponse listCustomLineItemsResponse = (ListCustomLineItemsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomLineItems").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCustomLineItemsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCustomLineItemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCustomLineItemsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$listCustomLineItems$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCustomLineItemsIterable listCustomLineItemsPaginator(ListCustomLineItemsRequest listCustomLineItemsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListCustomLineItemsIterable(this, this.applyPaginatorUserAgent(listCustomLineItemsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPricingPlansResponse listPricingPlans(ListPricingPlansRequest listPricingPlansRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPricingPlansResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, listPricingPlansRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPricingPlans");
            ListPricingPlansResponse listPricingPlansResponse = (ListPricingPlansResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPricingPlans").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPricingPlansRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPricingPlansRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPricingPlansResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$listPricingPlans$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPricingPlansIterable listPricingPlansPaginator(ListPricingPlansRequest listPricingPlansRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListPricingPlansIterable(this, this.applyPaginatorUserAgent(listPricingPlansRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPricingPlansAssociatedWithPricingRuleResponse listPricingPlansAssociatedWithPricingRule(ListPricingPlansAssociatedWithPricingRuleRequest listPricingPlansAssociatedWithPricingRuleRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPricingPlansAssociatedWithPricingRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, listPricingPlansAssociatedWithPricingRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPricingPlansAssociatedWithPricingRule");
            ListPricingPlansAssociatedWithPricingRuleResponse listPricingPlansAssociatedWithPricingRuleResponse = (ListPricingPlansAssociatedWithPricingRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPricingPlansAssociatedWithPricingRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPricingPlansAssociatedWithPricingRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPricingPlansAssociatedWithPricingRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPricingPlansAssociatedWithPricingRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$listPricingPlansAssociatedWithPricingRule$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPricingPlansAssociatedWithPricingRuleIterable listPricingPlansAssociatedWithPricingRulePaginator(ListPricingPlansAssociatedWithPricingRuleRequest listPricingPlansAssociatedWithPricingRuleRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListPricingPlansAssociatedWithPricingRuleIterable(this, this.applyPaginatorUserAgent(listPricingPlansAssociatedWithPricingRuleRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPricingRulesResponse listPricingRules(ListPricingRulesRequest listPricingRulesRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPricingRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, listPricingRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPricingRules");
            ListPricingRulesResponse listPricingRulesResponse = (ListPricingRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPricingRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPricingRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPricingRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPricingRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$listPricingRules$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPricingRulesIterable listPricingRulesPaginator(ListPricingRulesRequest listPricingRulesRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListPricingRulesIterable(this, this.applyPaginatorUserAgent(listPricingRulesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPricingRulesAssociatedToPricingPlanResponse listPricingRulesAssociatedToPricingPlan(ListPricingRulesAssociatedToPricingPlanRequest listPricingRulesAssociatedToPricingPlanRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPricingRulesAssociatedToPricingPlanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, listPricingRulesAssociatedToPricingPlanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPricingRulesAssociatedToPricingPlan");
            ListPricingRulesAssociatedToPricingPlanResponse listPricingRulesAssociatedToPricingPlanResponse = (ListPricingRulesAssociatedToPricingPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPricingRulesAssociatedToPricingPlan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPricingRulesAssociatedToPricingPlanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPricingRulesAssociatedToPricingPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPricingRulesAssociatedToPricingPlanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$listPricingRulesAssociatedToPricingPlan$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPricingRulesAssociatedToPricingPlanIterable listPricingRulesAssociatedToPricingPlanPaginator(ListPricingRulesAssociatedToPricingPlanRequest listPricingRulesAssociatedToPricingPlanRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListPricingRulesAssociatedToPricingPlanIterable(this, this.applyPaginatorUserAgent(listPricingRulesAssociatedToPricingPlanRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourcesAssociatedToCustomLineItemResponse listResourcesAssociatedToCustomLineItem(ListResourcesAssociatedToCustomLineItemRequest listResourcesAssociatedToCustomLineItemRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesAssociatedToCustomLineItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, listResourcesAssociatedToCustomLineItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourcesAssociatedToCustomLineItem");
            ListResourcesAssociatedToCustomLineItemResponse listResourcesAssociatedToCustomLineItemResponse = (ListResourcesAssociatedToCustomLineItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourcesAssociatedToCustomLineItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourcesAssociatedToCustomLineItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourcesAssociatedToCustomLineItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourcesAssociatedToCustomLineItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$listResourcesAssociatedToCustomLineItem$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListResourcesAssociatedToCustomLineItemIterable listResourcesAssociatedToCustomLineItemPaginator(ListResourcesAssociatedToCustomLineItemRequest listResourcesAssociatedToCustomLineItemRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListResourcesAssociatedToCustomLineItemIterable(this, this.applyPaginatorUserAgent(listResourcesAssociatedToCustomLineItemRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$listTagsForResource$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$tagResource$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$untagResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateBillingGroupResponse updateBillingGroup(UpdateBillingGroupRequest updateBillingGroupRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBillingGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, updateBillingGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBillingGroup");
            UpdateBillingGroupResponse updateBillingGroupResponse = (UpdateBillingGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBillingGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateBillingGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateBillingGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateBillingGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$updateBillingGroup$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCustomLineItemResponse updateCustomLineItem(UpdateCustomLineItemRequest updateCustomLineItemRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCustomLineItemResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, updateCustomLineItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCustomLineItem");
            UpdateCustomLineItemResponse updateCustomLineItemResponse = (UpdateCustomLineItemResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCustomLineItem").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCustomLineItemRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCustomLineItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCustomLineItemResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$updateCustomLineItem$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePricingPlanResponse updatePricingPlan(UpdatePricingPlanRequest updatePricingPlanRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePricingPlanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, updatePricingPlanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePricingPlan");
            UpdatePricingPlanResponse updatePricingPlanResponse = (UpdatePricingPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePricingPlan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePricingPlanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePricingPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePricingPlanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$updatePricingPlan$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePricingRuleResponse updatePricingRule(UpdatePricingRuleRequest updatePricingRuleRequest) throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePricingRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBillingconductorClient.resolveMetricPublishers(this.clientConfiguration, updatePricingRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePricingRule");
            UpdatePricingRuleResponse updatePricingRuleResponse = (UpdatePricingRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePricingRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePricingRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePricingRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePricingRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBillingconductorClient.lambda$updatePricingRule$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(BillingconductorException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceLimitExceededException").exceptionBuilderSupplier(ServiceLimitExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BillingconductorRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.19.4").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((BillingconductorRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updatePricingRule$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePricingPlan$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCustomLineItem$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBillingGroup$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourcesAssociatedToCustomLineItem$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPricingRulesAssociatedToPricingPlan$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPricingRules$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPricingPlansAssociatedWithPricingRule$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPricingPlans$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomLineItems$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCustomLineItemVersions$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBillingGroups$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBillingGroupCostReports$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccountAssociations$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociatePricingRules$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateAccounts$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePricingRule$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePricingPlan$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomLineItem$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBillingGroup$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPricingRule$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPricingPlan$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomLineItem$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBillingGroup$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDisassociateResourcesFromCustomLineItem$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchAssociateResourcesToCustomLineItem$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associatePricingRules$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateAccounts$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

