/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomLineItemBillingPeriodRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomLineItemBillingPeriodRange> {
    private static final SdkField<String> INCLUSIVE_START_BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InclusiveStartBillingPeriod").getter(CustomLineItemBillingPeriodRange.getter(CustomLineItemBillingPeriodRange::inclusiveStartBillingPeriod)).setter(CustomLineItemBillingPeriodRange.setter(Builder::inclusiveStartBillingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusiveStartBillingPeriod").build()}).build();
    private static final SdkField<String> EXCLUSIVE_END_BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExclusiveEndBillingPeriod").getter(CustomLineItemBillingPeriodRange.getter(CustomLineItemBillingPeriodRange::exclusiveEndBillingPeriod)).setter(CustomLineItemBillingPeriodRange.setter(Builder::exclusiveEndBillingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveEndBillingPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUSIVE_START_BILLING_PERIOD_FIELD, EXCLUSIVE_END_BILLING_PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inclusiveStartBillingPeriod;
    private final String exclusiveEndBillingPeriod;

    private CustomLineItemBillingPeriodRange(BuilderImpl builder) {
        this.inclusiveStartBillingPeriod = builder.inclusiveStartBillingPeriod;
        this.exclusiveEndBillingPeriod = builder.exclusiveEndBillingPeriod;
    }

    public final String inclusiveStartBillingPeriod() {
        return this.inclusiveStartBillingPeriod;
    }

    public final String exclusiveEndBillingPeriod() {
        return this.exclusiveEndBillingPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusiveStartBillingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveEndBillingPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLineItemBillingPeriodRange)) {
            return false;
        }
        CustomLineItemBillingPeriodRange other = (CustomLineItemBillingPeriodRange)obj;
        return Objects.equals(this.inclusiveStartBillingPeriod(), other.inclusiveStartBillingPeriod()) && Objects.equals(this.exclusiveEndBillingPeriod(), other.exclusiveEndBillingPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"CustomLineItemBillingPeriodRange").add("InclusiveStartBillingPeriod", (Object)this.inclusiveStartBillingPeriod()).add("ExclusiveEndBillingPeriod", (Object)this.exclusiveEndBillingPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InclusiveStartBillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.inclusiveStartBillingPeriod()));
            }
            case "ExclusiveEndBillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.exclusiveEndBillingPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomLineItemBillingPeriodRange, T> g) {
        return obj -> g.apply((CustomLineItemBillingPeriodRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inclusiveStartBillingPeriod;
        private String exclusiveEndBillingPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLineItemBillingPeriodRange model) {
            this.inclusiveStartBillingPeriod(model.inclusiveStartBillingPeriod);
            this.exclusiveEndBillingPeriod(model.exclusiveEndBillingPeriod);
        }

        public final String getInclusiveStartBillingPeriod() {
            return this.inclusiveStartBillingPeriod;
        }

        public final void setInclusiveStartBillingPeriod(String inclusiveStartBillingPeriod) {
            this.inclusiveStartBillingPeriod = inclusiveStartBillingPeriod;
        }

        @Override
        public final Builder inclusiveStartBillingPeriod(String inclusiveStartBillingPeriod) {
            this.inclusiveStartBillingPeriod = inclusiveStartBillingPeriod;
            return this;
        }

        public final String getExclusiveEndBillingPeriod() {
            return this.exclusiveEndBillingPeriod;
        }

        public final void setExclusiveEndBillingPeriod(String exclusiveEndBillingPeriod) {
            this.exclusiveEndBillingPeriod = exclusiveEndBillingPeriod;
        }

        @Override
        public final Builder exclusiveEndBillingPeriod(String exclusiveEndBillingPeriod) {
            this.exclusiveEndBillingPeriod = exclusiveEndBillingPeriod;
            return this;
        }

        public CustomLineItemBillingPeriodRange build() {
            return new CustomLineItemBillingPeriodRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomLineItemBillingPeriodRange> {
        public Builder inclusiveStartBillingPeriod(String var1);

        public Builder exclusiveEndBillingPeriod(String var1);
    }
}

