/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PricingRuleType {
    MARKUP("MARKUP"),
    DISCOUNT("DISCOUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PricingRuleType> VALUE_MAP;
    private final String value;

    private PricingRuleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PricingRuleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PricingRuleType> knownValues() {
        EnumSet<PricingRuleType> knownValues = EnumSet.allOf(PricingRuleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PricingRuleType.class, PricingRuleType::toString);
    }
}

