/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorAsyncClient;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse;

public class ListPricingPlansAssociatedWithPricingRulePublisher
implements SdkPublisher<ListPricingPlansAssociatedWithPricingRuleResponse> {
    private final BillingconductorAsyncClient client;
    private final ListPricingPlansAssociatedWithPricingRuleRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPricingPlansAssociatedWithPricingRulePublisher(BillingconductorAsyncClient client, ListPricingPlansAssociatedWithPricingRuleRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPricingPlansAssociatedWithPricingRulePublisher(BillingconductorAsyncClient client, ListPricingPlansAssociatedWithPricingRuleRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPricingPlansAssociatedWithPricingRuleResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPricingPlansAssociatedWithPricingRuleResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> pricingPlanArns() {
        Function<ListPricingPlansAssociatedWithPricingRuleResponse, Iterator> getIterator = response -> {
            if (response != null && response.pricingPlanArns() != null) {
                return response.pricingPlanArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPricingPlansAssociatedWithPricingRuleResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPricingPlansAssociatedWithPricingRuleResponseFetcher
    implements AsyncPageFetcher<ListPricingPlansAssociatedWithPricingRuleResponse> {
        private ListPricingPlansAssociatedWithPricingRuleResponseFetcher() {
        }

        public boolean hasNextPage(ListPricingPlansAssociatedWithPricingRuleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPricingPlansAssociatedWithPricingRuleResponse> nextPage(ListPricingPlansAssociatedWithPricingRuleResponse previousPage) {
            if (previousPage == null) {
                return ListPricingPlansAssociatedWithPricingRulePublisher.this.client.listPricingPlansAssociatedWithPricingRule(ListPricingPlansAssociatedWithPricingRulePublisher.this.firstRequest);
            }
            return ListPricingPlansAssociatedWithPricingRulePublisher.this.client.listPricingPlansAssociatedWithPricingRule((ListPricingPlansAssociatedWithPricingRuleRequest)((Object)ListPricingPlansAssociatedWithPricingRulePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

