/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemBillingPeriodRange;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemChargeDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCustomLineItemRequest
extends BillingconductorRequest
implements ToCopyableBuilder<Builder, UpdateCustomLineItemRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateCustomLineItemRequest.getter(UpdateCustomLineItemRequest::arn)).setter(UpdateCustomLineItemRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateCustomLineItemRequest.getter(UpdateCustomLineItemRequest::name)).setter(UpdateCustomLineItemRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateCustomLineItemRequest.getter(UpdateCustomLineItemRequest::description)).setter(UpdateCustomLineItemRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<UpdateCustomLineItemChargeDetails> CHARGE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChargeDetails").getter(UpdateCustomLineItemRequest.getter(UpdateCustomLineItemRequest::chargeDetails)).setter(UpdateCustomLineItemRequest.setter(Builder::chargeDetails)).constructor(UpdateCustomLineItemChargeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeDetails").build()}).build();
    private static final SdkField<CustomLineItemBillingPeriodRange> BILLING_PERIOD_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingPeriodRange").getter(UpdateCustomLineItemRequest.getter(UpdateCustomLineItemRequest::billingPeriodRange)).setter(UpdateCustomLineItemRequest.setter(Builder::billingPeriodRange)).constructor(CustomLineItemBillingPeriodRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriodRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CHARGE_DETAILS_FIELD, BILLING_PERIOD_RANGE_FIELD));
    private final String arn;
    private final String name;
    private final String description;
    private final UpdateCustomLineItemChargeDetails chargeDetails;
    private final CustomLineItemBillingPeriodRange billingPeriodRange;

    private UpdateCustomLineItemRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.chargeDetails = builder.chargeDetails;
        this.billingPeriodRange = builder.billingPeriodRange;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final UpdateCustomLineItemChargeDetails chargeDetails() {
        return this.chargeDetails;
    }

    public final CustomLineItemBillingPeriodRange billingPeriodRange() {
        return this.billingPeriodRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.chargeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingPeriodRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomLineItemRequest)) {
            return false;
        }
        UpdateCustomLineItemRequest other = (UpdateCustomLineItemRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.chargeDetails(), other.chargeDetails()) && Objects.equals(this.billingPeriodRange(), other.billingPeriodRange());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCustomLineItemRequest").add("Arn", (Object)this.arn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ChargeDetails", (Object)this.chargeDetails()).add("BillingPeriodRange", (Object)this.billingPeriodRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ChargeDetails": {
                return Optional.ofNullable(clazz.cast(this.chargeDetails()));
            }
            case "BillingPeriodRange": {
                return Optional.ofNullable(clazz.cast(this.billingPeriodRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomLineItemRequest, T> g) {
        return obj -> g.apply((UpdateCustomLineItemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private UpdateCustomLineItemChargeDetails chargeDetails;
        private CustomLineItemBillingPeriodRange billingPeriodRange;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomLineItemRequest model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.chargeDetails(model.chargeDetails);
            this.billingPeriodRange(model.billingPeriodRange);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final UpdateCustomLineItemChargeDetails.Builder getChargeDetails() {
            return this.chargeDetails != null ? this.chargeDetails.toBuilder() : null;
        }

        public final void setChargeDetails(UpdateCustomLineItemChargeDetails.BuilderImpl chargeDetails) {
            this.chargeDetails = chargeDetails != null ? chargeDetails.build() : null;
        }

        @Override
        public final Builder chargeDetails(UpdateCustomLineItemChargeDetails chargeDetails) {
            this.chargeDetails = chargeDetails;
            return this;
        }

        public final CustomLineItemBillingPeriodRange.Builder getBillingPeriodRange() {
            return this.billingPeriodRange != null ? this.billingPeriodRange.toBuilder() : null;
        }

        public final void setBillingPeriodRange(CustomLineItemBillingPeriodRange.BuilderImpl billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange != null ? billingPeriodRange.build() : null;
        }

        @Override
        public final Builder billingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCustomLineItemRequest build() {
            return new UpdateCustomLineItemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BillingconductorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCustomLineItemRequest> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder chargeDetails(UpdateCustomLineItemChargeDetails var1);

        default public Builder chargeDetails(Consumer<UpdateCustomLineItemChargeDetails.Builder> chargeDetails) {
            return this.chargeDetails((UpdateCustomLineItemChargeDetails)((UpdateCustomLineItemChargeDetails.Builder)UpdateCustomLineItemChargeDetails.builder().applyMutation(chargeDetails)).build());
        }

        public Builder billingPeriodRange(CustomLineItemBillingPeriodRange var1);

        default public Builder billingPeriodRange(Consumer<CustomLineItemBillingPeriodRange.Builder> billingPeriodRange) {
            return this.billingPeriodRange((CustomLineItemBillingPeriodRange)((CustomLineItemBillingPeriodRange.Builder)CustomLineItemBillingPeriodRange.builder().applyMutation(billingPeriodRange)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

