/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupCostReportElement;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupCostReportListCopier;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBillingGroupCostReportsResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, ListBillingGroupCostReportsResponse> {
    private static final SdkField<List<BillingGroupCostReportElement>> BILLING_GROUP_COST_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BillingGroupCostReports").getter(ListBillingGroupCostReportsResponse.getter(ListBillingGroupCostReportsResponse::billingGroupCostReports)).setter(ListBillingGroupCostReportsResponse.setter(Builder::billingGroupCostReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupCostReports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BillingGroupCostReportElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBillingGroupCostReportsResponse.getter(ListBillingGroupCostReportsResponse::nextToken)).setter(ListBillingGroupCostReportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUP_COST_REPORTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<BillingGroupCostReportElement> billingGroupCostReports;
    private final String nextToken;

    private ListBillingGroupCostReportsResponse(BuilderImpl builder) {
        super(builder);
        this.billingGroupCostReports = builder.billingGroupCostReports;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBillingGroupCostReports() {
        return this.billingGroupCostReports != null && !(this.billingGroupCostReports instanceof SdkAutoConstructList);
    }

    public final List<BillingGroupCostReportElement> billingGroupCostReports() {
        return this.billingGroupCostReports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBillingGroupCostReports() ? this.billingGroupCostReports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingGroupCostReportsResponse)) {
            return false;
        }
        ListBillingGroupCostReportsResponse other = (ListBillingGroupCostReportsResponse)((Object)obj);
        return this.hasBillingGroupCostReports() == other.hasBillingGroupCostReports() && Objects.equals(this.billingGroupCostReports(), other.billingGroupCostReports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBillingGroupCostReportsResponse").add("BillingGroupCostReports", this.hasBillingGroupCostReports() ? this.billingGroupCostReports() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BillingGroupCostReports": {
                return Optional.ofNullable(clazz.cast(this.billingGroupCostReports()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBillingGroupCostReportsResponse, T> g) {
        return obj -> g.apply((ListBillingGroupCostReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private List<BillingGroupCostReportElement> billingGroupCostReports = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingGroupCostReportsResponse model) {
            super(model);
            this.billingGroupCostReports(model.billingGroupCostReports);
            this.nextToken(model.nextToken);
        }

        public final List<BillingGroupCostReportElement.Builder> getBillingGroupCostReports() {
            List<BillingGroupCostReportElement.Builder> result = BillingGroupCostReportListCopier.copyToBuilder(this.billingGroupCostReports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBillingGroupCostReports(Collection<BillingGroupCostReportElement.BuilderImpl> billingGroupCostReports) {
            this.billingGroupCostReports = BillingGroupCostReportListCopier.copyFromBuilder(billingGroupCostReports);
        }

        @Override
        @Transient
        public final Builder billingGroupCostReports(Collection<BillingGroupCostReportElement> billingGroupCostReports) {
            this.billingGroupCostReports = BillingGroupCostReportListCopier.copy(billingGroupCostReports);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder billingGroupCostReports(BillingGroupCostReportElement ... billingGroupCostReports) {
            this.billingGroupCostReports(Arrays.asList(billingGroupCostReports));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder billingGroupCostReports(Consumer<BillingGroupCostReportElement.Builder> ... billingGroupCostReports) {
            this.billingGroupCostReports(Stream.of(billingGroupCostReports).map(c -> (BillingGroupCostReportElement)((BillingGroupCostReportElement.Builder)BillingGroupCostReportElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBillingGroupCostReportsResponse build() {
            return new ListBillingGroupCostReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBillingGroupCostReportsResponse> {
        public Builder billingGroupCostReports(Collection<BillingGroupCostReportElement> var1);

        public Builder billingGroupCostReports(BillingGroupCostReportElement ... var1);

        public Builder billingGroupCostReports(Consumer<BillingGroupCostReportElement.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

