/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billing.model.BillingViewType;
import software.amazon.awssdk.services.billing.model.Expression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillingViewElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillingViewElement> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(BillingViewElement.getter(BillingViewElement::arn)).setter(BillingViewElement.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(BillingViewElement.getter(BillingViewElement::name)).setter(BillingViewElement.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(BillingViewElement.getter(BillingViewElement::description)).setter(BillingViewElement.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> BILLING_VIEW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingViewType").getter(BillingViewElement.getter(BillingViewElement::billingViewTypeAsString)).setter(BillingViewElement.setter(Builder::billingViewType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingViewType").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccountId").getter(BillingViewElement.getter(BillingViewElement::ownerAccountId)).setter(BillingViewElement.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()}).build();
    private static final SdkField<Expression> DATA_FILTER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataFilterExpression").getter(BillingViewElement.getter(BillingViewElement::dataFilterExpression)).setter(BillingViewElement.setter(Builder::dataFilterExpression)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFilterExpression").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(BillingViewElement.getter(BillingViewElement::createdAt)).setter(BillingViewElement.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(BillingViewElement.getter(BillingViewElement::updatedAt)).setter(BillingViewElement.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, BILLING_VIEW_TYPE_FIELD, OWNER_ACCOUNT_ID_FIELD, DATA_FILTER_EXPRESSION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BillingViewElement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String description;
    private final String billingViewType;
    private final String ownerAccountId;
    private final Expression dataFilterExpression;
    private final Instant createdAt;
    private final Instant updatedAt;

    private BillingViewElement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.billingViewType = builder.billingViewType;
        this.ownerAccountId = builder.ownerAccountId;
        this.dataFilterExpression = builder.dataFilterExpression;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final BillingViewType billingViewType() {
        return BillingViewType.fromValue(this.billingViewType);
    }

    public final String billingViewTypeAsString() {
        return this.billingViewType;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final Expression dataFilterExpression() {
        return this.dataFilterExpression;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingViewTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFilterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingViewElement)) {
            return false;
        }
        BillingViewElement other = (BillingViewElement)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.billingViewTypeAsString(), other.billingViewTypeAsString()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.dataFilterExpression(), other.dataFilterExpression()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"BillingViewElement").add("Arn", (Object)this.arn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("BillingViewType", (Object)this.billingViewTypeAsString()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("DataFilterExpression", (Object)this.dataFilterExpression()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "billingViewType": {
                return Optional.ofNullable(clazz.cast(this.billingViewTypeAsString()));
            }
            case "ownerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "dataFilterExpression": {
                return Optional.ofNullable(clazz.cast(this.dataFilterExpression()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("billingViewType", BILLING_VIEW_TYPE_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("dataFilterExpression", DATA_FILTER_EXPRESSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillingViewElement, T> g) {
        return obj -> g.apply((BillingViewElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String billingViewType;
        private String ownerAccountId;
        private Expression dataFilterExpression;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingViewElement model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.billingViewType(model.billingViewType);
            this.ownerAccountId(model.ownerAccountId);
            this.dataFilterExpression(model.dataFilterExpression);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBillingViewType() {
            return this.billingViewType;
        }

        public final void setBillingViewType(String billingViewType) {
            this.billingViewType = billingViewType;
        }

        @Override
        public final Builder billingViewType(String billingViewType) {
            this.billingViewType = billingViewType;
            return this;
        }

        @Override
        public final Builder billingViewType(BillingViewType billingViewType) {
            this.billingViewType(billingViewType == null ? null : billingViewType.toString());
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final Expression.Builder getDataFilterExpression() {
            return this.dataFilterExpression != null ? this.dataFilterExpression.toBuilder() : null;
        }

        public final void setDataFilterExpression(Expression.BuilderImpl dataFilterExpression) {
            this.dataFilterExpression = dataFilterExpression != null ? dataFilterExpression.build() : null;
        }

        @Override
        public final Builder dataFilterExpression(Expression dataFilterExpression) {
            this.dataFilterExpression = dataFilterExpression;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public BillingViewElement build() {
            return new BillingViewElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillingViewElement> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder billingViewType(String var1);

        public Builder billingViewType(BillingViewType var1);

        public Builder ownerAccountId(String var1);

        public Builder dataFilterExpression(Expression var1);

        default public Builder dataFilterExpression(Consumer<Expression.Builder> dataFilterExpression) {
            return this.dataFilterExpression((Expression)((Expression.Builder)Expression.builder().applyMutation(dataFilterExpression)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

