/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.billing.BillingClientBuilder;
import software.amazon.awssdk.services.billing.BillingServiceClientConfiguration;
import software.amazon.awssdk.services.billing.DefaultBillingClientBuilder;
import software.amazon.awssdk.services.billing.model.AccessDeniedException;
import software.amazon.awssdk.services.billing.model.BillingException;
import software.amazon.awssdk.services.billing.model.InternalServerException;
import software.amazon.awssdk.services.billing.model.ListBillingViewsRequest;
import software.amazon.awssdk.services.billing.model.ListBillingViewsResponse;
import software.amazon.awssdk.services.billing.model.ThrottlingException;
import software.amazon.awssdk.services.billing.model.ValidationException;
import software.amazon.awssdk.services.billing.paginators.ListBillingViewsIterable;

@SdkPublicApi
@ThreadSafe
public interface BillingClient
extends AwsClient {
    public static final String SERVICE_NAME = "billing";
    public static final String SERVICE_METADATA_ID = "billing";

    default public ListBillingViewsResponse listBillingViews(ListBillingViewsRequest listBillingViewsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    default public ListBillingViewsResponse listBillingViews(Consumer<ListBillingViewsRequest.Builder> listBillingViewsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingException {
        return this.listBillingViews((ListBillingViewsRequest)((Object)((ListBillingViewsRequest.Builder)ListBillingViewsRequest.builder().applyMutation(listBillingViewsRequest)).build()));
    }

    default public ListBillingViewsIterable listBillingViewsPaginator(ListBillingViewsRequest listBillingViewsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingException {
        return new ListBillingViewsIterable(this, listBillingViewsRequest);
    }

    default public ListBillingViewsIterable listBillingViewsPaginator(Consumer<ListBillingViewsRequest.Builder> listBillingViewsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BillingException {
        return this.listBillingViewsPaginator((ListBillingViewsRequest)((Object)((ListBillingViewsRequest.Builder)ListBillingViewsRequest.builder().applyMutation(listBillingViewsRequest)).build()));
    }

    public static BillingClient create() {
        return (BillingClient)BillingClient.builder().build();
    }

    public static BillingClientBuilder builder() {
        return new DefaultBillingClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"billing");
    }

    default public BillingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

