/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.CitationsConfig;
import software.amazon.awssdk.services.bedrockruntime.model.SearchResultContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.SearchResultContentBlocksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchResultBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchResultBlock> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(SearchResultBlock.getter(SearchResultBlock::source)).setter(SearchResultBlock.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(SearchResultBlock.getter(SearchResultBlock::title)).setter(SearchResultBlock.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<List<SearchResultContentBlock>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("content").getter(SearchResultBlock.getter(SearchResultBlock::content)).setter(SearchResultBlock.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchResultContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CitationsConfig> CITATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("citations").getter(SearchResultBlock.getter(SearchResultBlock::citations)).setter(SearchResultBlock.setter(Builder::citations)).constructor(CitationsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TITLE_FIELD, CONTENT_FIELD, CITATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchResultBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String source;
    private final String title;
    private final List<SearchResultContentBlock> content;
    private final CitationsConfig citations;

    private SearchResultBlock(BuilderImpl builder) {
        this.source = builder.source;
        this.title = builder.title;
        this.content = builder.content;
        this.citations = builder.citations;
    }

    public final String source() {
        return this.source;
    }

    public final String title() {
        return this.title;
    }

    public final boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructList);
    }

    public final List<SearchResultContentBlock> content() {
        return this.content;
    }

    public final CitationsConfig citations() {
        return this.citations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContent() ? this.content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.citations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResultBlock)) {
            return false;
        }
        SearchResultBlock other = (SearchResultBlock)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.title(), other.title()) && this.hasContent() == other.hasContent() && Objects.equals(this.content(), other.content()) && Objects.equals(this.citations(), other.citations());
    }

    public final String toString() {
        return ToString.builder((String)"SearchResultBlock").add("Source", (Object)this.source()).add("Title", (Object)this.title()).add("Content", this.hasContent() ? this.content() : null).add("Citations", (Object)this.citations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "citations": {
                return Optional.ofNullable(clazz.cast(this.citations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("source", SOURCE_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("citations", CITATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchResultBlock, T> g) {
        return obj -> g.apply((SearchResultBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private String title;
        private List<SearchResultContentBlock> content = DefaultSdkAutoConstructList.getInstance();
        private CitationsConfig citations;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResultBlock model) {
            this.source(model.source);
            this.title(model.title);
            this.content(model.content);
            this.citations(model.citations);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final List<SearchResultContentBlock.Builder> getContent() {
            List<SearchResultContentBlock.Builder> result = SearchResultContentBlocksCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<SearchResultContentBlock.BuilderImpl> content) {
            this.content = SearchResultContentBlocksCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<SearchResultContentBlock> content) {
            this.content = SearchResultContentBlocksCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(SearchResultContentBlock ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<SearchResultContentBlock.Builder> ... content) {
            this.content(Stream.of(content).map(c -> (SearchResultContentBlock)((SearchResultContentBlock.Builder)SearchResultContentBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CitationsConfig.Builder getCitations() {
            return this.citations != null ? this.citations.toBuilder() : null;
        }

        public final void setCitations(CitationsConfig.BuilderImpl citations) {
            this.citations = citations != null ? citations.build() : null;
        }

        @Override
        public final Builder citations(CitationsConfig citations) {
            this.citations = citations;
            return this;
        }

        public SearchResultBlock build() {
            return new SearchResultBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchResultBlock> {
        public Builder source(String var1);

        public Builder title(String var1);

        public Builder content(Collection<SearchResultContentBlock> var1);

        public Builder content(SearchResultContentBlock ... var1);

        public Builder content(Consumer<SearchResultContentBlock.Builder> ... var1);

        public Builder citations(CitationsConfig var1);

        default public Builder citations(Consumer<CitationsConfig.Builder> citations) {
            return this.citations((CitationsConfig)((CitationsConfig.Builder)CitationsConfig.builder().applyMutation(citations)).build());
        }
    }
}

