/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A search result block that enables natural citations with proper source attribution for retrieved content.
 * </p>
 * <note>
 * <p>
 * This field is only supported by Anthropic Claude Opus 4.1, Opus 4, Sonnet 4.5, Sonnet 4, Sonnet 3.7, and 3.5 Haiku
 * models.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResultBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchResultBlock.Builder, SearchResultBlock> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(SearchResultBlock::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(SearchResultBlock::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<List<SearchResultContentBlock>> CONTENT_FIELD = SdkField
            .<List<SearchResultContentBlock>> builder(MarshallingType.LIST)
            .memberName("content")
            .getter(getter(SearchResultBlock::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchResultContentBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchResultContentBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CitationsConfig> CITATIONS_FIELD = SdkField.<CitationsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("citations").getter(getter(SearchResultBlock::citations)).setter(setter(Builder::citations))
            .constructor(CitationsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TITLE_FIELD,
            CONTENT_FIELD, CITATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String title;

    private final List<SearchResultContentBlock> content;

    private final CitationsConfig citations;

    private SearchResultBlock(BuilderImpl builder) {
        this.source = builder.source;
        this.title = builder.title;
        this.content = builder.content;
        this.citations = builder.citations;
    }

    /**
     * <p>
     * The source URL or identifier for the content.
     * </p>
     * 
     * @return The source URL or identifier for the content.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * A descriptive title for the search result.
     * </p>
     * 
     * @return A descriptive title for the search result.
     */
    public final String title() {
        return title;
    }

    /**
     * For responses, this returns true if the service returned a value for the Content property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContent() {
        return content != null && !(content instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of search result content block.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContent} method.
     * </p>
     * 
     * @return An array of search result content block.
     */
    public final List<SearchResultContentBlock> content() {
        return content;
    }

    /**
     * <p>
     * Configuration setting for citations
     * </p>
     * 
     * @return Configuration setting for citations
     */
    public final CitationsConfig citations() {
        return citations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(hasContent() ? content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(citations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResultBlock)) {
            return false;
        }
        SearchResultBlock other = (SearchResultBlock) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(title(), other.title())
                && hasContent() == other.hasContent() && Objects.equals(content(), other.content())
                && Objects.equals(citations(), other.citations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchResultBlock").add("Source", source()).add("Title", title())
                .add("Content", hasContent() ? content() : null).add("Citations", citations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "citations":
            return Optional.ofNullable(clazz.cast(citations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("citations", CITATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchResultBlock, T> g) {
        return obj -> g.apply((SearchResultBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchResultBlock> {
        /**
         * <p>
         * The source URL or identifier for the content.
         * </p>
         * 
         * @param source
         *        The source URL or identifier for the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * A descriptive title for the search result.
         * </p>
         * 
         * @param title
         *        A descriptive title for the search result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * An array of search result content block.
         * </p>
         * 
         * @param content
         *        An array of search result content block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Collection<SearchResultContentBlock> content);

        /**
         * <p>
         * An array of search result content block.
         * </p>
         * 
         * @param content
         *        An array of search result content block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(SearchResultContentBlock... content);

        /**
         * <p>
         * An array of search result content block.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.SearchResultContentBlock.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.SearchResultContentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.SearchResultContentBlock.Builder#build()} is
         * called immediately and its result is passed to {@link #content(List<SearchResultContentBlock>)}.
         * 
         * @param content
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.SearchResultContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(java.util.Collection<SearchResultContentBlock>)
         */
        Builder content(Consumer<SearchResultContentBlock.Builder>... content);

        /**
         * <p>
         * Configuration setting for citations
         * </p>
         * 
         * @param citations
         *        Configuration setting for citations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citations(CitationsConfig citations);

        /**
         * <p>
         * Configuration setting for citations
         * </p>
         * This is a convenience method that creates an instance of the {@link CitationsConfig.Builder} avoiding the
         * need to create one manually via {@link CitationsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CitationsConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #citations(CitationsConfig)}.
         * 
         * @param citations
         *        a consumer that will call methods on {@link CitationsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #citations(CitationsConfig)
         */
        default Builder citations(Consumer<CitationsConfig.Builder> citations) {
            return citations(CitationsConfig.builder().applyMutation(citations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String title;

        private List<SearchResultContentBlock> content = DefaultSdkAutoConstructList.getInstance();

        private CitationsConfig citations;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResultBlock model) {
            source(model.source);
            title(model.title);
            content(model.content);
            citations(model.citations);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final List<SearchResultContentBlock.Builder> getContent() {
            List<SearchResultContentBlock.Builder> result = SearchResultContentBlocksCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<SearchResultContentBlock.BuilderImpl> content) {
            this.content = SearchResultContentBlocksCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<SearchResultContentBlock> content) {
            this.content = SearchResultContentBlocksCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(SearchResultContentBlock... content) {
            content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<SearchResultContentBlock.Builder>... content) {
            content(Stream.of(content).map(c -> SearchResultContentBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final CitationsConfig.Builder getCitations() {
            return citations != null ? citations.toBuilder() : null;
        }

        public final void setCitations(CitationsConfig.BuilderImpl citations) {
            this.citations = citations != null ? citations.build() : null;
        }

        @Override
        public final Builder citations(CitationsConfig citations) {
            this.citations = citations;
            return this;
        }

        @Override
        public SearchResultBlock build() {
            return new SearchResultBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
