/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content filter for a guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailContentFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailContentFilter.Builder, GuardrailContentFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GuardrailContentFilter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> CONFIDENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("confidence").getter(getter(GuardrailContentFilter::confidenceAsString))
            .setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidence").build()).build();

    private static final SdkField<String> FILTER_STRENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterStrength").getter(getter(GuardrailContentFilter::filterStrengthAsString))
            .setter(setter(Builder::filterStrength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterStrength").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GuardrailContentFilter::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Boolean> DETECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("detected").getter(getter(GuardrailContentFilter::detected)).setter(setter(Builder::detected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detected").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONFIDENCE_FIELD,
            FILTER_STRENGTH_FIELD, ACTION_FIELD, DETECTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String confidence;

    private final String filterStrength;

    private final String action;

    private final Boolean detected;

    private GuardrailContentFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.confidence = builder.confidence;
        this.filterStrength = builder.filterStrength;
        this.action = builder.action;
        this.detected = builder.detected;
    }

    /**
     * <p>
     * The guardrail type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailContentFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The guardrail type.
     * @see GuardrailContentFilterType
     */
    public final GuardrailContentFilterType type() {
        return GuardrailContentFilterType.fromValue(type);
    }

    /**
     * <p>
     * The guardrail type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailContentFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The guardrail type.
     * @see GuardrailContentFilterType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The guardrail confidence.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #confidence} will
     * return {@link GuardrailContentFilterConfidence#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #confidenceAsString}.
     * </p>
     * 
     * @return The guardrail confidence.
     * @see GuardrailContentFilterConfidence
     */
    public final GuardrailContentFilterConfidence confidence() {
        return GuardrailContentFilterConfidence.fromValue(confidence);
    }

    /**
     * <p>
     * The guardrail confidence.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #confidence} will
     * return {@link GuardrailContentFilterConfidence#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #confidenceAsString}.
     * </p>
     * 
     * @return The guardrail confidence.
     * @see GuardrailContentFilterConfidence
     */
    public final String confidenceAsString() {
        return confidence;
    }

    /**
     * <p>
     * The filter strength setting for the guardrail content filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterStrength}
     * will return {@link GuardrailContentFilterStrength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #filterStrengthAsString}.
     * </p>
     * 
     * @return The filter strength setting for the guardrail content filter.
     * @see GuardrailContentFilterStrength
     */
    public final GuardrailContentFilterStrength filterStrength() {
        return GuardrailContentFilterStrength.fromValue(filterStrength);
    }

    /**
     * <p>
     * The filter strength setting for the guardrail content filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterStrength}
     * will return {@link GuardrailContentFilterStrength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #filterStrengthAsString}.
     * </p>
     * 
     * @return The filter strength setting for the guardrail content filter.
     * @see GuardrailContentFilterStrength
     */
    public final String filterStrengthAsString() {
        return filterStrength;
    }

    /**
     * <p>
     * The guardrail action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailContentPolicyAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The guardrail action.
     * @see GuardrailContentPolicyAction
     */
    public final GuardrailContentPolicyAction action() {
        return GuardrailContentPolicyAction.fromValue(action);
    }

    /**
     * <p>
     * The guardrail action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailContentPolicyAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #actionAsString}.
     * </p>
     * 
     * @return The guardrail action.
     * @see GuardrailContentPolicyAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Indicates whether content that breaches the guardrail configuration is detected.
     * </p>
     * 
     * @return Indicates whether content that breaches the guardrail configuration is detected.
     */
    public final Boolean detected() {
        return detected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(confidenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterStrengthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(detected());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContentFilter)) {
            return false;
        }
        GuardrailContentFilter other = (GuardrailContentFilter) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(confidenceAsString(), other.confidenceAsString())
                && Objects.equals(filterStrengthAsString(), other.filterStrengthAsString())
                && Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(detected(), other.detected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailContentFilter").add("Type", typeAsString()).add("Confidence", confidenceAsString())
                .add("FilterStrength", filterStrengthAsString()).add("Action", actionAsString()).add("Detected", detected())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "confidence":
            return Optional.ofNullable(clazz.cast(confidenceAsString()));
        case "filterStrength":
            return Optional.ofNullable(clazz.cast(filterStrengthAsString()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "detected":
            return Optional.ofNullable(clazz.cast(detected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("confidence", CONFIDENCE_FIELD);
        map.put("filterStrength", FILTER_STRENGTH_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("detected", DETECTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContentFilter, T> g) {
        return obj -> g.apply((GuardrailContentFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailContentFilter> {
        /**
         * <p>
         * The guardrail type.
         * </p>
         * 
         * @param type
         *        The guardrail type.
         * @see GuardrailContentFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentFilterType
         */
        Builder type(String type);

        /**
         * <p>
         * The guardrail type.
         * </p>
         * 
         * @param type
         *        The guardrail type.
         * @see GuardrailContentFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentFilterType
         */
        Builder type(GuardrailContentFilterType type);

        /**
         * <p>
         * The guardrail confidence.
         * </p>
         * 
         * @param confidence
         *        The guardrail confidence.
         * @see GuardrailContentFilterConfidence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentFilterConfidence
         */
        Builder confidence(String confidence);

        /**
         * <p>
         * The guardrail confidence.
         * </p>
         * 
         * @param confidence
         *        The guardrail confidence.
         * @see GuardrailContentFilterConfidence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentFilterConfidence
         */
        Builder confidence(GuardrailContentFilterConfidence confidence);

        /**
         * <p>
         * The filter strength setting for the guardrail content filter.
         * </p>
         * 
         * @param filterStrength
         *        The filter strength setting for the guardrail content filter.
         * @see GuardrailContentFilterStrength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentFilterStrength
         */
        Builder filterStrength(String filterStrength);

        /**
         * <p>
         * The filter strength setting for the guardrail content filter.
         * </p>
         * 
         * @param filterStrength
         *        The filter strength setting for the guardrail content filter.
         * @see GuardrailContentFilterStrength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentFilterStrength
         */
        Builder filterStrength(GuardrailContentFilterStrength filterStrength);

        /**
         * <p>
         * The guardrail action.
         * </p>
         * 
         * @param action
         *        The guardrail action.
         * @see GuardrailContentPolicyAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentPolicyAction
         */
        Builder action(String action);

        /**
         * <p>
         * The guardrail action.
         * </p>
         * 
         * @param action
         *        The guardrail action.
         * @see GuardrailContentPolicyAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentPolicyAction
         */
        Builder action(GuardrailContentPolicyAction action);

        /**
         * <p>
         * Indicates whether content that breaches the guardrail configuration is detected.
         * </p>
         * 
         * @param detected
         *        Indicates whether content that breaches the guardrail configuration is detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detected(Boolean detected);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String confidence;

        private String filterStrength;

        private String action;

        private Boolean detected;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContentFilter model) {
            type(model.type);
            confidence(model.confidence);
            filterStrength(model.filterStrength);
            action(model.action);
            detected(model.detected);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailContentFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getConfidence() {
            return confidence;
        }

        public final void setConfidence(String confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(String confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public final Builder confidence(GuardrailContentFilterConfidence confidence) {
            this.confidence(confidence == null ? null : confidence.toString());
            return this;
        }

        public final String getFilterStrength() {
            return filterStrength;
        }

        public final void setFilterStrength(String filterStrength) {
            this.filterStrength = filterStrength;
        }

        @Override
        public final Builder filterStrength(String filterStrength) {
            this.filterStrength = filterStrength;
            return this;
        }

        @Override
        public final Builder filterStrength(GuardrailContentFilterStrength filterStrength) {
            this.filterStrength(filterStrength == null ? null : filterStrength.toString());
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailContentPolicyAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Boolean getDetected() {
            return detected;
        }

        public final void setDetected(Boolean detected) {
            this.detected = detected;
        }

        @Override
        public final Builder detected(Boolean detected) {
            this.detected = detected;
            return this;
        }

        @Override
        public GuardrailContentFilter build() {
            return new GuardrailContentFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
