/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeModelWithResponseStreamResponse extends BedrockRuntimeResponse implements
        ToCopyableBuilder<InvokeModelWithResponseStreamResponse.Builder, InvokeModelWithResponseStreamResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("contentType")
            .getter(getter(InvokeModelWithResponseStreamResponse::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-Content-Type").build())
            .build();

    private static final SdkField<String> PERFORMANCE_CONFIG_LATENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("performanceConfigLatency")
            .getter(getter(InvokeModelWithResponseStreamResponse::performanceConfigLatencyAsString))
            .setter(setter(Builder::performanceConfigLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("X-Amzn-Bedrock-PerformanceConfig-Latency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            PERFORMANCE_CONFIG_LATENCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contentType;

    private final String performanceConfigLatency;

    private InvokeModelWithResponseStreamResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.performanceConfigLatency = builder.performanceConfigLatency;
    }

    /**
     * <p>
     * The MIME type of the inference result.
     * </p>
     * 
     * @return The MIME type of the inference result.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Model performance settings for the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #performanceConfigLatency} will return {@link PerformanceConfigLatency#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #performanceConfigLatencyAsString}.
     * </p>
     * 
     * @return Model performance settings for the request.
     * @see PerformanceConfigLatency
     */
    public final PerformanceConfigLatency performanceConfigLatency() {
        return PerformanceConfigLatency.fromValue(performanceConfigLatency);
    }

    /**
     * <p>
     * Model performance settings for the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #performanceConfigLatency} will return {@link PerformanceConfigLatency#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #performanceConfigLatencyAsString}.
     * </p>
     * 
     * @return Model performance settings for the request.
     * @see PerformanceConfigLatency
     */
    public final String performanceConfigLatencyAsString() {
        return performanceConfigLatency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(performanceConfigLatencyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeModelWithResponseStreamResponse)) {
            return false;
        }
        InvokeModelWithResponseStreamResponse other = (InvokeModelWithResponseStreamResponse) obj;
        return Objects.equals(contentType(), other.contentType())
                && Objects.equals(performanceConfigLatencyAsString(), other.performanceConfigLatencyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeModelWithResponseStreamResponse").add("ContentType", contentType())
                .add("PerformanceConfigLatency", performanceConfigLatencyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "performanceConfigLatency":
            return Optional.ofNullable(clazz.cast(performanceConfigLatencyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("X-Amzn-Bedrock-Content-Type", CONTENT_TYPE_FIELD);
        map.put("X-Amzn-Bedrock-PerformanceConfig-Latency", PERFORMANCE_CONFIG_LATENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeModelWithResponseStreamResponse, T> g) {
        return obj -> g.apply((InvokeModelWithResponseStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeModelWithResponseStreamResponse> {
        /**
         * <p>
         * The MIME type of the inference result.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the inference result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Model performance settings for the request.
         * </p>
         * 
         * @param performanceConfigLatency
         *        Model performance settings for the request.
         * @see PerformanceConfigLatency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceConfigLatency
         */
        Builder performanceConfigLatency(String performanceConfigLatency);

        /**
         * <p>
         * Model performance settings for the request.
         * </p>
         * 
         * @param performanceConfigLatency
         *        Model performance settings for the request.
         * @see PerformanceConfigLatency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceConfigLatency
         */
        Builder performanceConfigLatency(PerformanceConfigLatency performanceConfigLatency);
    }

    static final class BuilderImpl extends BedrockRuntimeResponse.BuilderImpl implements Builder {
        private String contentType;

        private String performanceConfigLatency;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeModelWithResponseStreamResponse model) {
            super(model);
            contentType(model.contentType);
            performanceConfigLatency(model.performanceConfigLatency);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getPerformanceConfigLatency() {
            return performanceConfigLatency;
        }

        public final void setPerformanceConfigLatency(String performanceConfigLatency) {
            this.performanceConfigLatency = performanceConfigLatency;
        }

        @Override
        public final Builder performanceConfigLatency(String performanceConfigLatency) {
            this.performanceConfigLatency = performanceConfigLatency;
            return this;
        }

        @Override
        public final Builder performanceConfigLatency(PerformanceConfigLatency performanceConfigLatency) {
            this.performanceConfigLatency(performanceConfigLatency == null ? null : performanceConfigLatency.toString());
            return this;
        }

        @Override
        public InvokeModelWithResponseStreamResponse build() {
            return new InvokeModelWithResponseStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
