/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of an asynchronous invocation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AsyncInvokeSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AsyncInvokeSummary.Builder, AsyncInvokeSummary> {
    private static final SdkField<String> INVOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationArn").getter(getter(AsyncInvokeSummary::invocationArn)).setter(setter(Builder::invocationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationArn").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(AsyncInvokeSummary::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(AsyncInvokeSummary::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AsyncInvokeSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(AsyncInvokeSummary::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("submitTime")
            .getter(getter(AsyncInvokeSummary::submitTime))
            .setter(setter(Builder::submitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submitTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(AsyncInvokeSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(AsyncInvokeSummary::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<AsyncInvokeOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<AsyncInvokeOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("outputDataConfig")
            .getter(getter(AsyncInvokeSummary::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(AsyncInvokeOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_ARN_FIELD,
            MODEL_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD, STATUS_FIELD, FAILURE_MESSAGE_FIELD, SUBMIT_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, END_TIME_FIELD, OUTPUT_DATA_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String invocationArn;

    private final String modelArn;

    private final String clientRequestToken;

    private final String status;

    private final String failureMessage;

    private final Instant submitTime;

    private final Instant lastModifiedTime;

    private final Instant endTime;

    private final AsyncInvokeOutputDataConfig outputDataConfig;

    private AsyncInvokeSummary(BuilderImpl builder) {
        this.invocationArn = builder.invocationArn;
        this.modelArn = builder.modelArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.status = builder.status;
        this.failureMessage = builder.failureMessage;
        this.submitTime = builder.submitTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.endTime = builder.endTime;
        this.outputDataConfig = builder.outputDataConfig;
    }

    /**
     * <p>
     * The invocation's ARN.
     * </p>
     * 
     * @return The invocation's ARN.
     */
    public final String invocationArn() {
        return invocationArn;
    }

    /**
     * <p>
     * The invoked model's ARN.
     * </p>
     * 
     * @return The invoked model's ARN.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The invocation's idempotency token.
     * </p>
     * 
     * @return The invocation's idempotency token.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The invocation's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AsyncInvokeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The invocation's status.
     * @see AsyncInvokeStatus
     */
    public final AsyncInvokeStatus status() {
        return AsyncInvokeStatus.fromValue(status);
    }

    /**
     * <p>
     * The invocation's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AsyncInvokeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The invocation's status.
     * @see AsyncInvokeStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An error message.
     * </p>
     * 
     * @return An error message.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * When the invocation was submitted.
     * </p>
     * 
     * @return When the invocation was submitted.
     */
    public final Instant submitTime() {
        return submitTime;
    }

    /**
     * <p>
     * When the invocation was last modified.
     * </p>
     * 
     * @return When the invocation was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * When the invocation ended.
     * </p>
     * 
     * @return When the invocation ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The invocation's output data settings.
     * </p>
     * 
     * @return The invocation's output data settings.
     */
    public final AsyncInvokeOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invocationArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInvokeSummary)) {
            return false;
        }
        AsyncInvokeSummary other = (AsyncInvokeSummary) obj;
        return Objects.equals(invocationArn(), other.invocationArn()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureMessage(), other.failureMessage()) && Objects.equals(submitTime(), other.submitTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(outputDataConfig(), other.outputDataConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AsyncInvokeSummary").add("InvocationArn", invocationArn()).add("ModelArn", modelArn())
                .add("ClientRequestToken", clientRequestToken()).add("Status", statusAsString())
                .add("FailureMessage", failureMessage() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SubmitTime", submitTime()).add("LastModifiedTime", lastModifiedTime()).add("EndTime", endTime())
                .add("OutputDataConfig", outputDataConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invocationArn":
            return Optional.ofNullable(clazz.cast(invocationArn()));
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "submitTime":
            return Optional.ofNullable(clazz.cast(submitTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "outputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invocationArn", INVOCATION_ARN_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("submitTime", SUBMIT_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("outputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AsyncInvokeSummary, T> g) {
        return obj -> g.apply((AsyncInvokeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AsyncInvokeSummary> {
        /**
         * <p>
         * The invocation's ARN.
         * </p>
         * 
         * @param invocationArn
         *        The invocation's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationArn(String invocationArn);

        /**
         * <p>
         * The invoked model's ARN.
         * </p>
         * 
         * @param modelArn
         *        The invoked model's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The invocation's idempotency token.
         * </p>
         * 
         * @param clientRequestToken
         *        The invocation's idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The invocation's status.
         * </p>
         * 
         * @param status
         *        The invocation's status.
         * @see AsyncInvokeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsyncInvokeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The invocation's status.
         * </p>
         * 
         * @param status
         *        The invocation's status.
         * @see AsyncInvokeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsyncInvokeStatus
         */
        Builder status(AsyncInvokeStatus status);

        /**
         * <p>
         * An error message.
         * </p>
         * 
         * @param failureMessage
         *        An error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * When the invocation was submitted.
         * </p>
         * 
         * @param submitTime
         *        When the invocation was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTime(Instant submitTime);

        /**
         * <p>
         * When the invocation was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the invocation was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * When the invocation ended.
         * </p>
         * 
         * @param endTime
         *        When the invocation ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The invocation's output data settings.
         * </p>
         * 
         * @param outputDataConfig
         *        The invocation's output data settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(AsyncInvokeOutputDataConfig outputDataConfig);

        /**
         * <p>
         * The invocation's output data settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link AsyncInvokeOutputDataConfig.Builder}
         * avoiding the need to create one manually via {@link AsyncInvokeOutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AsyncInvokeOutputDataConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputDataConfig(AsyncInvokeOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link AsyncInvokeOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(AsyncInvokeOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<AsyncInvokeOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(AsyncInvokeOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String invocationArn;

        private String modelArn;

        private String clientRequestToken;

        private String status;

        private String failureMessage;

        private Instant submitTime;

        private Instant lastModifiedTime;

        private Instant endTime;

        private AsyncInvokeOutputDataConfig outputDataConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInvokeSummary model) {
            invocationArn(model.invocationArn);
            modelArn(model.modelArn);
            clientRequestToken(model.clientRequestToken);
            status(model.status);
            failureMessage(model.failureMessage);
            submitTime(model.submitTime);
            lastModifiedTime(model.lastModifiedTime);
            endTime(model.endTime);
            outputDataConfig(model.outputDataConfig);
        }

        public final String getInvocationArn() {
            return invocationArn;
        }

        public final void setInvocationArn(String invocationArn) {
            this.invocationArn = invocationArn;
        }

        @Override
        public final Builder invocationArn(String invocationArn) {
            this.invocationArn = invocationArn;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AsyncInvokeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final Instant getSubmitTime() {
            return submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final AsyncInvokeOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(AsyncInvokeOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(AsyncInvokeOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        @Override
        public AsyncInvokeSummary build() {
            return new AsyncInvokeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
