/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolInputSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolInputSchema> {
    private static final SdkField<Document> JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("json").getter(ToolInputSchema.getter(ToolInputSchema::json)).setter(ToolInputSchema.setter(Builder::json)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("json").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("json", JSON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Document json;
    private final Type type;

    private ToolInputSchema(BuilderImpl builder) {
        this.json = builder.json;
        this.type = builder.type;
    }

    public final Document json() {
        return this.json;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.json());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolInputSchema)) {
            return false;
        }
        ToolInputSchema other = (ToolInputSchema)obj;
        return Objects.equals(this.json(), other.json());
    }

    public final String toString() {
        return ToString.builder((String)"ToolInputSchema").add("Json", (Object)this.json()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "json": {
                return Optional.ofNullable(clazz.cast(this.json()));
            }
        }
        return Optional.empty();
    }

    public static ToolInputSchema fromJson(Document json) {
        return (ToolInputSchema)ToolInputSchema.builder().json(json).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ToolInputSchema, T> g) {
        return obj -> g.apply((ToolInputSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        JSON,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Document json;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ToolInputSchema model) {
            this.json(model.json);
        }

        public final Document getJson() {
            return this.json;
        }

        public final void setJson(Document json) {
            Document oldValue = this.json;
            this.json = json;
            this.handleUnionValueChange(Type.JSON, oldValue, this.json);
        }

        @Override
        public final Builder json(Document json) {
            Document oldValue = this.json;
            this.json = json;
            this.handleUnionValueChange(Type.JSON, oldValue, this.json);
            return this;
        }

        public ToolInputSchema build() {
            return new ToolInputSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolInputSchema> {
        public Builder json(Document var1);
    }
}

