/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.BedrockRuntimeRequest;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentBlockListCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplyGuardrailRequest
extends BedrockRuntimeRequest
implements ToCopyableBuilder<Builder, ApplyGuardrailRequest> {
    private static final SdkField<String> GUARDRAIL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailIdentifier").getter(ApplyGuardrailRequest.getter(ApplyGuardrailRequest::guardrailIdentifier)).setter(ApplyGuardrailRequest.setter(Builder::guardrailIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("guardrailIdentifier").build()}).build();
    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailVersion").getter(ApplyGuardrailRequest.getter(ApplyGuardrailRequest::guardrailVersion)).setter(ApplyGuardrailRequest.setter(Builder::guardrailVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("guardrailVersion").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(ApplyGuardrailRequest.getter(ApplyGuardrailRequest::sourceAsString)).setter(ApplyGuardrailRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<List<GuardrailContentBlock>> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("content").getter(ApplyGuardrailRequest.getter(ApplyGuardrailRequest::content)).setter(ApplyGuardrailRequest.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_IDENTIFIER_FIELD, GUARDRAIL_VERSION_FIELD, SOURCE_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("guardrailIdentifier", GUARDRAIL_IDENTIFIER_FIELD);
            this.put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
            this.put("source", SOURCE_FIELD);
            this.put("content", CONTENT_FIELD);
        }
    });
    private final String guardrailIdentifier;
    private final String guardrailVersion;
    private final String source;
    private final List<GuardrailContentBlock> content;

    private ApplyGuardrailRequest(BuilderImpl builder) {
        super(builder);
        this.guardrailIdentifier = builder.guardrailIdentifier;
        this.guardrailVersion = builder.guardrailVersion;
        this.source = builder.source;
        this.content = builder.content;
    }

    public final String guardrailIdentifier() {
        return this.guardrailIdentifier;
    }

    public final String guardrailVersion() {
        return this.guardrailVersion;
    }

    public final GuardrailContentSource source() {
        return GuardrailContentSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final boolean hasContent() {
        return this.content != null && !(this.content instanceof SdkAutoConstructList);
    }

    public final List<GuardrailContentBlock> content() {
        return this.content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContent() ? this.content() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyGuardrailRequest)) {
            return false;
        }
        ApplyGuardrailRequest other = (ApplyGuardrailRequest)((Object)obj);
        return Objects.equals(this.guardrailIdentifier(), other.guardrailIdentifier()) && Objects.equals(this.guardrailVersion(), other.guardrailVersion()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && this.hasContent() == other.hasContent() && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"ApplyGuardrailRequest").add("GuardrailIdentifier", (Object)this.guardrailIdentifier()).add("GuardrailVersion", (Object)this.guardrailVersion()).add("Source", (Object)this.sourceAsString()).add("Content", this.hasContent() ? this.content() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailIdentifier": {
                return Optional.ofNullable(clazz.cast(this.guardrailIdentifier()));
            }
            case "guardrailVersion": {
                return Optional.ofNullable(clazz.cast(this.guardrailVersion()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ApplyGuardrailRequest, T> g) {
        return obj -> g.apply((ApplyGuardrailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRuntimeRequest.BuilderImpl
    implements Builder {
        private String guardrailIdentifier;
        private String guardrailVersion;
        private String source;
        private List<GuardrailContentBlock> content = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyGuardrailRequest model) {
            super(model);
            this.guardrailIdentifier(model.guardrailIdentifier);
            this.guardrailVersion(model.guardrailVersion);
            this.source(model.source);
            this.content(model.content);
        }

        public final String getGuardrailIdentifier() {
            return this.guardrailIdentifier;
        }

        public final void setGuardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
        }

        @Override
        public final Builder guardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
            return this;
        }

        public final String getGuardrailVersion() {
            return this.guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(GuardrailContentSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final List<GuardrailContentBlock.Builder> getContent() {
            List<GuardrailContentBlock.Builder> result = GuardrailContentBlockListCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<GuardrailContentBlock.BuilderImpl> content) {
            this.content = GuardrailContentBlockListCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<GuardrailContentBlock> content) {
            this.content = GuardrailContentBlockListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(GuardrailContentBlock ... content) {
            this.content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<GuardrailContentBlock.Builder> ... content) {
            this.content(Stream.of(content).map(c -> (GuardrailContentBlock)((GuardrailContentBlock.Builder)GuardrailContentBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApplyGuardrailRequest build() {
            return new ApplyGuardrailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ApplyGuardrailRequest> {
        public Builder guardrailIdentifier(String var1);

        public Builder guardrailVersion(String var1);

        public Builder source(String var1);

        public Builder source(GuardrailContentSource var1);

        public Builder content(Collection<GuardrailContentBlock> var1);

        public Builder content(GuardrailContentBlock ... var1);

        public Builder content(Consumer<GuardrailContentBlock.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

