/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for a guardrail that you use with the <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailConfiguration.Builder, GuardrailConfiguration> {
    private static final SdkField<String> GUARDRAIL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailIdentifier").getter(getter(GuardrailConfiguration::guardrailIdentifier))
            .setter(setter(Builder::guardrailIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailIdentifier").build())
            .build();

    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailVersion").getter(getter(GuardrailConfiguration::guardrailVersion))
            .setter(setter(Builder::guardrailVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailVersion").build()).build();

    private static final SdkField<String> TRACE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("trace")
            .getter(getter(GuardrailConfiguration::traceAsString)).setter(setter(Builder::trace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_IDENTIFIER_FIELD,
            GUARDRAIL_VERSION_FIELD, TRACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String guardrailIdentifier;

    private final String guardrailVersion;

    private final String trace;

    private GuardrailConfiguration(BuilderImpl builder) {
        this.guardrailIdentifier = builder.guardrailIdentifier;
        this.guardrailVersion = builder.guardrailVersion;
        this.trace = builder.trace;
    }

    /**
     * <p>
     * The identifier for the guardrail.
     * </p>
     * 
     * @return The identifier for the guardrail.
     */
    public final String guardrailIdentifier() {
        return guardrailIdentifier;
    }

    /**
     * <p>
     * The version of the guardrail.
     * </p>
     * 
     * @return The version of the guardrail.
     */
    public final String guardrailVersion() {
        return guardrailVersion;
    }

    /**
     * <p>
     * The trace behavior for the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trace} will return
     * {@link GuardrailTrace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceAsString}.
     * </p>
     * 
     * @return The trace behavior for the guardrail.
     * @see GuardrailTrace
     */
    public final GuardrailTrace trace() {
        return GuardrailTrace.fromValue(trace);
    }

    /**
     * <p>
     * The trace behavior for the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trace} will return
     * {@link GuardrailTrace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceAsString}.
     * </p>
     * 
     * @return The trace behavior for the guardrail.
     * @see GuardrailTrace
     */
    public final String traceAsString() {
        return trace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guardrailIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(traceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailConfiguration)) {
            return false;
        }
        GuardrailConfiguration other = (GuardrailConfiguration) obj;
        return Objects.equals(guardrailIdentifier(), other.guardrailIdentifier())
                && Objects.equals(guardrailVersion(), other.guardrailVersion())
                && Objects.equals(traceAsString(), other.traceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailConfiguration").add("GuardrailIdentifier", guardrailIdentifier())
                .add("GuardrailVersion", guardrailVersion()).add("Trace", traceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailIdentifier":
            return Optional.ofNullable(clazz.cast(guardrailIdentifier()));
        case "guardrailVersion":
            return Optional.ofNullable(clazz.cast(guardrailVersion()));
        case "trace":
            return Optional.ofNullable(clazz.cast(traceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailConfiguration, T> g) {
        return obj -> g.apply((GuardrailConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailConfiguration> {
        /**
         * <p>
         * The identifier for the guardrail.
         * </p>
         * 
         * @param guardrailIdentifier
         *        The identifier for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailIdentifier(String guardrailIdentifier);

        /**
         * <p>
         * The version of the guardrail.
         * </p>
         * 
         * @param guardrailVersion
         *        The version of the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailVersion(String guardrailVersion);

        /**
         * <p>
         * The trace behavior for the guardrail.
         * </p>
         * 
         * @param trace
         *        The trace behavior for the guardrail.
         * @see GuardrailTrace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailTrace
         */
        Builder trace(String trace);

        /**
         * <p>
         * The trace behavior for the guardrail.
         * </p>
         * 
         * @param trace
         *        The trace behavior for the guardrail.
         * @see GuardrailTrace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailTrace
         */
        Builder trace(GuardrailTrace trace);
    }

    static final class BuilderImpl implements Builder {
        private String guardrailIdentifier;

        private String guardrailVersion;

        private String trace;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailConfiguration model) {
            guardrailIdentifier(model.guardrailIdentifier);
            guardrailVersion(model.guardrailVersion);
            trace(model.trace);
        }

        public final String getGuardrailIdentifier() {
            return guardrailIdentifier;
        }

        public final void setGuardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
        }

        @Override
        public final Builder guardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
            return this;
        }

        public final String getGuardrailVersion() {
            return guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final String getTrace() {
            return trace;
        }

        public final void setTrace(String trace) {
            this.trace = trace;
        }

        @Override
        public final Builder trace(String trace) {
            this.trace = trace;
            return this;
        }

        @Override
        public final Builder trace(GuardrailTrace trace) {
            this.trace(trace == null ? null : trace.toString());
            return this;
        }

        @Override
        public GuardrailConfiguration build() {
            return new GuardrailConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
