/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for the tools that you pass to a model.
 * </p>
 * <note>
 * <p>
 * This field is only supported by Anthropic Claude 3, Cohere Command R, Cohere Command R+, and Mistral Large models.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ToolConfiguration.Builder, ToolConfiguration> {
    private static final SdkField<List<Tool>> TOOLS_FIELD = SdkField
            .<List<Tool>> builder(MarshallingType.LIST)
            .memberName("tools")
            .getter(getter(ToolConfiguration::tools))
            .setter(setter(Builder::tools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tool> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tool::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ToolChoice> TOOL_CHOICE_FIELD = SdkField.<ToolChoice> builder(MarshallingType.SDK_POJO)
            .memberName("toolChoice").getter(getter(ToolConfiguration::toolChoice)).setter(setter(Builder::toolChoice))
            .constructor(ToolChoice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolChoice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TOOLS_FIELD, TOOL_CHOICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Tool> tools;

    private final ToolChoice toolChoice;

    private ToolConfiguration(BuilderImpl builder) {
        this.tools = builder.tools;
        this.toolChoice = builder.toolChoice;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tools property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTools() {
        return tools != null && !(tools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of tools that you want to pass to a model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTools} method.
     * </p>
     * 
     * @return An array of tools that you want to pass to a model.
     */
    public final List<Tool> tools() {
        return tools;
    }

    /**
     * <p>
     * If supported by model, forces the model to request a tool.
     * </p>
     * 
     * @return If supported by model, forces the model to request a tool.
     */
    public final ToolChoice toolChoice() {
        return toolChoice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTools() ? tools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(toolChoice());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolConfiguration)) {
            return false;
        }
        ToolConfiguration other = (ToolConfiguration) obj;
        return hasTools() == other.hasTools() && Objects.equals(tools(), other.tools())
                && Objects.equals(toolChoice(), other.toolChoice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolConfiguration").add("Tools", hasTools() ? tools() : null).add("ToolChoice", toolChoice())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tools":
            return Optional.ofNullable(clazz.cast(tools()));
        case "toolChoice":
            return Optional.ofNullable(clazz.cast(toolChoice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ToolConfiguration, T> g) {
        return obj -> g.apply((ToolConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolConfiguration> {
        /**
         * <p>
         * An array of tools that you want to pass to a model.
         * </p>
         * 
         * @param tools
         *        An array of tools that you want to pass to a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(Collection<Tool> tools);

        /**
         * <p>
         * An array of tools that you want to pass to a model.
         * </p>
         * 
         * @param tools
         *        An array of tools that you want to pass to a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tools(Tool... tools);

        /**
         * <p>
         * An array of tools that you want to pass to a model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.Tool.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrockruntime.model.Tool#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.Tool.Builder#build()} is called immediately and
         * its result is passed to {@link #tools(List<Tool>)}.
         * 
         * @param tools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.Tool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tools(java.util.Collection<Tool>)
         */
        Builder tools(Consumer<Tool.Builder>... tools);

        /**
         * <p>
         * If supported by model, forces the model to request a tool.
         * </p>
         * 
         * @param toolChoice
         *        If supported by model, forces the model to request a tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolChoice(ToolChoice toolChoice);

        /**
         * <p>
         * If supported by model, forces the model to request a tool.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolChoice.Builder} avoiding the need to
         * create one manually via {@link ToolChoice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolChoice.Builder#build()} is called immediately and its result
         * is passed to {@link #toolChoice(ToolChoice)}.
         * 
         * @param toolChoice
         *        a consumer that will call methods on {@link ToolChoice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolChoice(ToolChoice)
         */
        default Builder toolChoice(Consumer<ToolChoice.Builder> toolChoice) {
            return toolChoice(ToolChoice.builder().applyMutation(toolChoice).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Tool> tools = DefaultSdkAutoConstructList.getInstance();

        private ToolChoice toolChoice;

        private BuilderImpl() {
        }

        private BuilderImpl(ToolConfiguration model) {
            tools(model.tools);
            toolChoice(model.toolChoice);
        }

        public final List<Tool.Builder> getTools() {
            List<Tool.Builder> result = ToolConfigurationToolsListCopier.copyToBuilder(this.tools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTools(Collection<Tool.BuilderImpl> tools) {
            this.tools = ToolConfigurationToolsListCopier.copyFromBuilder(tools);
        }

        @Override
        public final Builder tools(Collection<Tool> tools) {
            this.tools = ToolConfigurationToolsListCopier.copy(tools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Tool... tools) {
            tools(Arrays.asList(tools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tools(Consumer<Tool.Builder>... tools) {
            tools(Stream.of(tools).map(c -> Tool.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ToolChoice.Builder getToolChoice() {
            return toolChoice != null ? toolChoice.toBuilder() : null;
        }

        public final void setToolChoice(ToolChoice.BuilderImpl toolChoice) {
            this.toolChoice = toolChoice != null ? toolChoice.build() : null;
        }

        @Override
        public final Builder toolChoice(ToolChoice toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        @Override
        public ToolConfiguration build() {
            return new ToolConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
