/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PIIEntityType {
    ALL("ALL"),
    ADDRESS("ADDRESS"),
    AGE("AGE"),
    NAME("NAME"),
    EMAIL("EMAIL"),
    PHONE("PHONE"),
    USERNAME("USERNAME"),
    PASSWORD("PASSWORD"),
    DRIVER_ID("DRIVER_ID"),
    LICENSE_PLATE("LICENSE_PLATE"),
    VEHICLE_IDENTIFICATION_NUMBER("VEHICLE_IDENTIFICATION_NUMBER"),
    CREDIT_DEBIT_CARD_CVV("CREDIT_DEBIT_CARD_CVV"),
    CREDIT_DEBIT_CARD_EXPIRY("CREDIT_DEBIT_CARD_EXPIRY"),
    CREDIT_DEBIT_CARD_NUMBER("CREDIT_DEBIT_CARD_NUMBER"),
    PIN("PIN"),
    INTERNATIONAL_BANK_ACCOUNT_NUMBER("INTERNATIONAL_BANK_ACCOUNT_NUMBER"),
    SWIFT_CODE("SWIFT_CODE"),
    IP_ADDRESS("IP_ADDRESS"),
    MAC_ADDRESS("MAC_ADDRESS"),
    URL("URL"),
    AWS_ACCESS_KEY("AWS_ACCESS_KEY"),
    AWS_SECRET_KEY("AWS_SECRET_KEY"),
    US_BANK_ACCOUNT_NUMBER("US_BANK_ACCOUNT_NUMBER"),
    US_BANK_ROUTING_NUMBER("US_BANK_ROUTING_NUMBER"),
    US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER("US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER"),
    US_PASSPORT_NUMBER("US_PASSPORT_NUMBER"),
    US_SOCIAL_SECURITY_NUMBER("US_SOCIAL_SECURITY_NUMBER"),
    CA_HEALTH_NUMBER("CA_HEALTH_NUMBER"),
    CA_SOCIAL_INSURANCE_NUMBER("CA_SOCIAL_INSURANCE_NUMBER"),
    UK_NATIONAL_HEALTH_SERVICE_NUMBER("UK_NATIONAL_HEALTH_SERVICE_NUMBER"),
    UK_NATIONAL_INSURANCE_NUMBER("UK_NATIONAL_INSURANCE_NUMBER"),
    UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER("UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PIIEntityType> VALUE_MAP;
    private final String value;

    private PIIEntityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PIIEntityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PIIEntityType> knownValues() {
        EnumSet<PIIEntityType> knownValues = EnumSet.allOf(PIIEntityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PIIEntityType.class, PIIEntityType::toString);
    }
}

